/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.client;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.client.core.central.ChannelHandleWrapper;
import com.codinglitch.simpleradio.client.core.central.ClientRouterWrapper;
import com.codinglitch.simpleradio.client.core.central.EffectStream;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundSpeakSoundPacket;
import com.codinglitch.simpleradio.core.networking.packets.ServerboundRequestRouterPacket;
import com.codinglitch.simpleradio.core.registry.SimpleRadioParticles;
import com.codinglitch.simpleradio.core.registry.blocks.MicrophoneBlock;
import com.codinglitch.simpleradio.core.registry.blocks.MicrophoneBlockEntity;
import com.codinglitch.simpleradio.core.registry.blocks.SpeakerBlock;
import com.codinglitch.simpleradio.core.registry.blocks.SpeakerBlockEntity;
import com.codinglitch.simpleradio.platform.ClientServices;
import com.codinglitch.simpleradio.radio.RadioListener;
import com.codinglitch.simpleradio.radio.RadioReceiver;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.codinglitch.simpleradio.radio.RadioSpeaker;
import com.codinglitch.simpleradio.radio.RadioTransmitter;
import com.codinglitch.simpleradio.radio.effects.BaseAudioEffect;
import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.Library;
import com.mojang.blaze3d.audio.SoundBuffer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.maxhenkel.voicechat.api.events.ClientReceiveSoundEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Predicate;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ClientRadioManager {
    private static final Map<Short, PendingRouter<?>> pendingRouters = new HashMap();
    private static final Map<Short, ClientRouterWrapper> routers = new HashMap<Short, ClientRouterWrapper>();

    public static List<RadioRouter> getRouters() {
        return routers.values().stream().map(wrapper -> wrapper.router).toList();
    }

    public static RadioRouter getRouter(Predicate<RadioRouter> criteria) {
        Optional<Map.Entry> result = routers.entrySet().stream().filter(entry -> criteria.test(((ClientRouterWrapper)entry.getValue()).router)).findFirst();
        return result.map(Map.Entry::getValue).map(wrapper -> wrapper.router).orElse(null);
    }

    public static ClientRouterWrapper getWrapper(Predicate<ClientRouterWrapper> criteria) {
        Optional<Map.Entry> result = routers.entrySet().stream().filter(entry -> criteria.test((ClientRouterWrapper)entry.getValue())).findFirst();
        return result.map(Map.Entry::getValue).orElse(null);
    }

    public static ClientRouterWrapper getWrapper(UUID uuid) {
        return ClientRadioManager.getWrapper((ClientRouterWrapper wrapper) -> uuid.equals(wrapper.router.reference));
    }

    public static ClientRouterWrapper getWrapper(RadioRouter router) {
        return ClientRadioManager.getWrapper((ClientRouterWrapper wrapper) -> router.equals(wrapper.router));
    }

    public static RadioRouter getRouter(short identifier) {
        ClientRouterWrapper wrapper = routers.get(identifier);
        return wrapper == null ? null : wrapper.router;
    }

    public static RadioRouter getRouter(UUID reference, @Nullable String type) {
        return ClientRadioManager.getRouter((RadioRouter router) -> router.reference.equals(reference) && (type == null ? router.getClass().equals(RadioRouter.class) : router.getClass().getSimpleName().equals(type)));
    }

    public static RadioRouter getRouter(UUID reference) {
        return ClientRadioManager.getRouter((RadioRouter router) -> reference.equals(router.reference));
    }

    public static RadioRouter getRouter(Entity owner) {
        return ClientRadioManager.getRouter((RadioRouter router) -> owner.equals((Object)router.owner));
    }

    public static RadioRouter getRouter(WorldlyPosition location) {
        return ClientRadioManager.getRouter((RadioRouter router) -> location.equals(router.location));
    }

    public static RadioListener getListener(UUID uuid) {
        return (RadioListener)ClientRadioManager.getRouter((RadioRouter router) -> uuid.equals(router.reference) && router instanceof RadioListener);
    }

    public static RadioListener getListener(Entity owner) {
        return (RadioListener)ClientRadioManager.getRouter((RadioRouter router) -> owner.equals((Object)router.owner) && router instanceof RadioListener);
    }

    public static RadioListener getListener(WorldlyPosition location) {
        return (RadioListener)ClientRadioManager.getRouter((RadioRouter router) -> location.equals(router.location) && router instanceof RadioListener);
    }

    public static RadioSpeaker getSpeaker(UUID uuid) {
        return (RadioSpeaker)ClientRadioManager.getRouter((RadioRouter router) -> uuid.equals(router.reference) && router instanceof RadioSpeaker);
    }

    public static RadioSpeaker getSpeaker(Entity owner) {
        return (RadioSpeaker)ClientRadioManager.getRouter((RadioRouter router) -> owner.equals((Object)router.owner) && router instanceof RadioSpeaker);
    }

    public static RadioSpeaker getSpeaker(WorldlyPosition location) {
        return (RadioSpeaker)ClientRadioManager.getRouter((RadioRouter router) -> location.equals(router.location) && router instanceof RadioSpeaker);
    }

    public static RadioReceiver getReceiver(UUID uuid) {
        return (RadioReceiver)ClientRadioManager.getRouter((RadioRouter router) -> uuid.equals(router.reference) && router instanceof RadioReceiver);
    }

    public static RadioReceiver getReceiver(Entity owner) {
        return (RadioReceiver)ClientRadioManager.getRouter((RadioRouter router) -> owner.equals((Object)router.owner) && router instanceof RadioReceiver);
    }

    public static RadioReceiver getReceiver(WorldlyPosition location) {
        return (RadioReceiver)ClientRadioManager.getRouter((RadioRouter router) -> location.equals(router.location) && router instanceof RadioReceiver);
    }

    public static RadioTransmitter getTransmitter(UUID uuid) {
        return (RadioTransmitter)ClientRadioManager.getRouter((RadioRouter router) -> uuid.equals(router.reference) && router instanceof RadioTransmitter);
    }

    public static RadioTransmitter getTransmitter(Entity owner) {
        return (RadioTransmitter)ClientRadioManager.getRouter((RadioRouter router) -> owner.equals((Object)router.owner) && router instanceof RadioTransmitter);
    }

    public static RadioTransmitter getTransmitter(WorldlyPosition location) {
        return (RadioTransmitter)ClientRadioManager.getRouter((RadioRouter router) -> location.equals(router.location) && router instanceof RadioTransmitter);
    }

    public static void finalizeRouter(short mapping, short identifier) {
        CommonSimpleRadio.debug("Received identifier {} for mapping {}", identifier, mapping);
        PendingRouter<?> pending = pendingRouters.remove(mapping);
        if (pending == null) {
            CommonSimpleRadio.warn("This should not happen! We could not find the router with mapping {} the server attempted to finalize with identifier {}!", mapping, identifier);
            return;
        }
        ((RadioRouter)pending.router).identifier = identifier;
        routers.put(identifier, ClientRouterWrapper.of(pending.router));
    }

    public static <R extends RadioRouter> void registerRouter(R router) {
        PendingRouter<R> pendingRouter = PendingRouter.of(router);
        short mapping = Short.MAX_VALUE;
        for (short index = Short.MIN_VALUE; index < Short.MAX_VALUE; index = (short)(index + 1)) {
            if (pendingRouters.containsKey(index)) continue;
            pendingRouters.put(index, pendingRouter);
            mapping = index;
            break;
        }
        pendingRouter.request(mapping);
        CommonSimpleRadio.debug("Requested identifier for {} with mapping {} and reference {}", router.getClass().getSimpleName(), mapping, router.getReference());
    }

    public static void removeRouter(Predicate<ClientRouterWrapper> predicate) {
        routers.entrySet().removeIf(entry -> {
            if (predicate.test((ClientRouterWrapper)entry.getValue())) {
                ((ClientRouterWrapper)entry.getValue()).close();
                return true;
            }
            return false;
        });
    }

    public static void removeRouter(RadioRouter router) {
        ClientRadioManager.removeRouter((ClientRouterWrapper wrapper) -> wrapper.router == router);
    }

    public static void removeRouter(UUID uuid) {
        ClientRadioManager.removeRouter((ClientRouterWrapper wrapper) -> uuid.equals(wrapper.router.reference));
    }

    public static void removeRouter(Entity owner) {
        ClientRadioManager.removeRouter((ClientRouterWrapper wrapper) -> owner.equals((Object)wrapper.router.owner));
    }

    public static void removeRouter(WorldlyPosition location) {
        ClientRadioManager.removeRouter((ClientRouterWrapper wrapper) -> wrapper.router.location != null && location.equals(wrapper.router.location));
    }

    public static void garbageCollect() {
        ClientRadioManager.removeRouter((ClientRouterWrapper wrapper) -> !wrapper.router.validate());
        ClientRadioManager.removeRouter((ClientRouterWrapper wrapper) -> wrapper.router.owner == null && wrapper.router.location == null);
        pendingRouters.entrySet().removeIf(entry -> ((PendingRouter)entry.getValue()).router == null || !((RadioRouter)((PendingRouter)entry.getValue()).router).validate());
        pendingRouters.entrySet().removeIf(entry -> ((PendingRouter)entry.getValue()).router == null || ((RadioRouter)((PendingRouter)entry.getValue()).router).owner == null && ((RadioRouter)((PendingRouter)entry.getValue()).router).location == null);
    }

    public static void tick(long gameTime) {
        if (gameTime % 20L == 0L) {
            ClientRadioManager.garbageCollect();
            Iterator<Map.Entry<Short, PendingRouter<?>>> iterator = pendingRouters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Short, PendingRouter<?>> entry = iterator.next();
                short mapping = entry.getKey();
                PendingRouter<?> pending = entry.getValue();
                if (pending.request(mapping)) {
                    CommonSimpleRadio.debug("We missed a router, so re-requesting identifier for {} with mapping {} and reference {}", pending.getClass().getSimpleName(), mapping, ((RadioRouter)pending.router).getReference());
                    continue;
                }
                iterator.remove();
            }
        }
        for (Map.Entry<Short, ClientRouterWrapper> wrapperEntry : routers.entrySet()) {
            ClientRouterWrapper wrapper = wrapperEntry.getValue();
            wrapper.router.tick(0);
            for (Map.Entry<Long, ChannelHandleWrapper> entry : wrapper.audioChannels.entrySet()) {
                entry.getValue().execute(channel -> channel.m_83654_(new Vec3(wrapper.router.getLocation().position())));
            }
        }
    }

    public static void close() {
        pendingRouters.clear();
        routers.clear();
    }

    public static void speakSound(ClientboundSpeakSoundPacket packet) {
        EffectStream stream;
        Minecraft mc = Minecraft.m_91087_();
        SoundManager soundManager = mc.m_91106_();
        SoundEngine soundEngine = soundManager.f_120349_;
        ClientRouterWrapper wrapper = ClientRadioManager.getWrapper(packet.routerID());
        if (wrapper == null) {
            return;
        }
        RadioRouter router = wrapper.router;
        if (router == null) {
            return;
        }
        WorldlyPosition location = router.getLocation();
        Vec3 position = new Vec3(location.position());
        ChannelHandleWrapper existingChannelHandle = wrapper.getChannel(packet.seed());
        if (existingChannelHandle != null) {
            if (existingChannelHandle.channelHandle.m_120151_()) {
                wrapper.removeChannel(packet.seed());
            } else {
                if (((SoundEvent)packet.sound().m_203334_()).m_11660_().equals((Object)SoundEvents.f_271165_.m_11660_()) && packet.volume() == 0.0f) {
                    existingChannelHandle.execute(Channel::m_83679_);
                } else {
                    existingChannelHandle.effect.severity = packet.severity();
                    existingChannelHandle.effect.volume = packet.volume();
                    existingChannelHandle.execute(channel -> channel.m_83654_(position));
                }
                return;
            }
        }
        if (((SoundEvent)packet.sound().m_203334_()).m_11660_().equals((Object)SoundEvents.f_271165_.m_11660_()) && packet.volume() == 0.0f) {
            return;
        }
        SimpleSoundInstance instance = new SimpleSoundInstance((SoundEvent)packet.sound().m_203334_(), SoundSource.BLOCKS, packet.volume(), packet.pitch(), RandomSource.m_216335_((long)packet.seed()), location.blockPos());
        instance.m_6775_(soundManager);
        Sound sound = instance.m_5891_();
        ResourceLocation path = sound.m_119790_();
        CompletableFuture completableFuture = soundEngine.f_120224_.m_120128_(sound.m_119796_() ? Library.Pool.STREAMING : Library.Pool.STATIC);
        ChannelAccess.ChannelHandle channelHandle = (ChannelAccess.ChannelHandle)completableFuture.join();
        float attenuatedVolume = Math.max((float)packet.volume(), (float)1.0f) * (float)sound.m_119798_();
        channelHandle.m_120154_(channel -> {
            channel.m_83650_(packet.pitch());
            channel.m_83666_(packet.volume());
            if (instance.m_7438_() == SoundInstance.Attenuation.LINEAR) {
                channel.m_83673_(attenuatedVolume);
            } else {
                channel.m_83681_();
            }
            channel.m_83654_(position);
            channel.m_83670_(instance.m_7796_());
        });
        try {
            InputStream inputStream = soundEngine.f_120222_.f_120189_.m_215595_(path);
            stream = new EffectStream(inputStream);
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
        AudioFormat format = stream.m_6206_();
        BaseAudioEffect effect = new BaseAudioEffect();
        effect.volume = 1.0f;
        effect.severity = packet.severity();
        stream.effect = effect;
        if (sound.m_119796_()) {
            ChannelHandleWrapper channelWrapper = ChannelHandleWrapper.of(channelHandle);
            channelWrapper.effect = effect;
            wrapper.addChannel(packet.seed(), channelWrapper);
            channelHandle.m_120154_(channel -> {
                if (packet.offset() != 0.0f) {
                    int sampleOffset = (int)(packet.offset() * (float)format.getSampleSizeInBits() / 8.0f * (float)format.getChannels() * format.getSampleRate());
                    try {
                        stream.push(sampleOffset);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                channel.m_83658_((AudioStream)stream);
                channel.m_83672_();
            });
        } else {
            ByteBuffer byteBuffer;
            try {
                byteBuffer = stream.m_83764_();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            SoundBuffer soundBuffer = new SoundBuffer(byteBuffer, format);
            channelHandle.m_120154_(channel -> {
                channel.m_83656_(soundBuffer);
                channel.m_83672_();
            });
        }
    }

    public static void handleListenParticle(BlockState state, MicrophoneBlockEntity blockEntity) {
        RadioRouter mainRouter = blockEntity.getRouter();
        if (mainRouter == null) {
            return;
        }
        float rotation = RotationSegment.m_245107_((int)((Integer)state.m_61143_((Property)MicrophoneBlock.ROTATION)));
        Vector3f direction = new Vector3f(0.0f, 1.0f, 0.0f);
        direction.rotateX(blockEntity.currentTilt);
        direction.rotateY(Math.toRadians((float)(-rotation)));
        WorldlyPosition position = mainRouter.getLocation();
        if (mainRouter.rotation != null) {
            mainRouter.rotation.transform(direction);
        }
        Vector3f pos = position.add(direction.x * 0.4f, direction.y * 0.4f, direction.z * 0.4f, new Vector3f());
        blockEntity.m_58904_().m_7106_((ParticleOptions)SimpleRadioParticles.LISTEN, (double)pos.x, (double)pos.y, (double)pos.z, (double)(direction.x * 0.01f), (double)(direction.y * 0.01f), (double)(direction.z * 0.01f));
    }

    public static void handleSpeakParticle(BlockState state, SpeakerBlockEntity blockEntity) {
        Entity camera;
        RadioRouter mainRouter = blockEntity.getRouter();
        if (mainRouter == null) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)SpeakerBlock.FACING);
        Vec3i dir = direction.m_122436_();
        Vector3f transformedDir = new Vector3f((float)dir.m_123341_(), (float)dir.m_123342_(), (float)dir.m_123343_());
        WorldlyPosition position = mainRouter.getLocation();
        Vec3 blockPosition = blockEntity.m_58899_().m_252807_();
        if (mainRouter.rotation != null) {
            mainRouter.rotation.transform(transformedDir);
        }
        if ((camera = Minecraft.m_91087_().f_91075_) == null) {
            return;
        }
        float dot = transformedDir.normalize().dot((Vector3fc)camera.m_20182_().m_252839_().sub((Vector3fc)position).normalize());
        if (Math.abs((float)dot) > 0.65f) {
            Vec3 pos = blockPosition.m_231075_(direction, 0.55);
            blockEntity.m_58904_().m_7106_((ParticleOptions)SimpleRadioParticles.SPEAK_RING, pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)((float)dir.m_123341_() * 0.01f), (double)((float)dir.m_123342_() * 0.01f), (double)((float)dir.m_123343_() * 0.01f));
        } else {
            Vec3 pos = blockPosition.m_231075_(direction, 0.9);
            blockEntity.m_58904_().m_7106_((ParticleOptions)SimpleRadioParticles.SPEAK_LINE, pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)((float)dir.m_123341_() * 0.01f), (double)((float)dir.m_123342_() * 0.01f), (double)((float)dir.m_123343_() * 0.01f));
        }
    }

    public static void renderRouter(RadioRouter router, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, Vector3f camera) {
        poseStack.m_85836_();
        Vector3f location = null;
        if (router.location != null) {
            location = new Vector3f(router.location.x, router.location.y, router.location.z);
        } else if (router.owner != null) {
            location = router.owner.m_20182_().m_252839_();
        }
        if (location == null) {
            return;
        }
        float r = 0.1f;
        float g = 0.1f;
        float b = 0.1f;
        if (router instanceof RadioListener) {
            r = 1.0f;
            g = 1.0f;
        } else if (router instanceof RadioSpeaker) {
            r = 1.0f;
            b = 1.0f;
        } else if (router instanceof RadioReceiver) {
            r = 1.0f;
        } else if (router instanceof RadioTransmitter) {
            b = 1.0f;
        } else {
            g = 1.0f;
        }
        location = location.sub((Vector3fc)camera);
        poseStack.m_252880_(location.x, location.y, location.z);
        if (router.rotation != null) {
            poseStack.m_252781_(router.rotation);
        }
        Vector3f newOffset = router.connectionOffset == Vec3.f_82478_ ? new Vector3f() : router.connectionOffset.m_252839_();
        AABB pointBox = new AABB((double)-0.05f, (double)-0.05f, (double)-0.05f, (double)0.05f, (double)0.05f, (double)0.05f).m_82386_((double)newOffset.x, (double)newOffset.y, (double)newOffset.z);
        DebugRenderer.m_269311_((PoseStack)poseStack, (MultiBufferSource)bufferSource, (AABB)pointBox, (float)r, (float)g, (float)b, (float)0.8f);
        AABB boundingBox = new AABB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5);
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)bufferSource.m_6299_(RenderType.m_110504_()), (AABB)boundingBox, (float)r, (float)g, (float)b, (float)0.8f);
        poseStack.m_85849_();
    }

    public static void onSoundEvent(ClientReceiveSoundEvent receiveSoundEvent) {
        CommonSimpleRadio.info(receiveSoundEvent.getId(), new Object[0]);
    }

    public static class PendingRouter<R extends RadioRouter> {
        public final R router;
        public int attempts = 0;

        public PendingRouter(R router) {
            this.router = router;
        }

        public boolean request(short mapping) {
            if (this.attempts > 5) {
                CommonSimpleRadio.warn("Attempted to request identifier for {} with mapping {} and reference {} at {} with no response after 5 tries. This could be indicative of a greater issue.", new Object[]{this.router.getClass().getSimpleName(), mapping, ((RadioRouter)this.router).getReference(), ((RadioRouter)this.router).location});
                return false;
            }
            ++this.attempts;
            ClientServices.NETWORKING.sendToServer(new ServerboundRequestRouterPacket(((RadioRouter)this.router).getReference(), this.router.getClass().getSimpleName(), mapping));
            return true;
        }

        public static <R extends RadioRouter> PendingRouter<R> of(R router) {
            return new PendingRouter<R>(router);
        }
    }
}

