/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.saturn.common.config;

import com.abdelaziz.saturn.common.config.Option;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.List;

public class SaturnOptions {
    private static final Option OPTIMIZE_MEMORY_ALLOCATION;
    private static final Option REDUCE_GC_HEAP;
    private static final Option FIX_MEMORY_LEAKS;
    private static final Option REMOVE_THREADING_DETECTOR_LOCKS;
    private static final List<Option> options;

    public static List<Option> getOptions() {
        return options;
    }

    public static Option createOption(String name, String description, String mixinClassPath, boolean value) {
        Option option = new Option(name, description, mixinClassPath, value);
        options.add(option);
        return option;
    }

    static {
        options = new ReferenceArrayList();
        OPTIMIZE_MEMORY_ALLOCATION = SaturnOptions.createOption("optimizeMemoryAllocations", "(default = true) Optimizes memory allocation by caching objects to static final references.", "allocations", true);
        REDUCE_GC_HEAP = SaturnOptions.createOption("reduceGCHeap", "(default = true) Reduces garbage collection (GC) heap by avoid creating unnecessary objects.", "gc_heap", true);
        FIX_MEMORY_LEAKS = SaturnOptions.createOption("fixMemoryLeaks", "(default = true) Fixes memory leaks which takes the memory continuously.", "leaks", true);
        REMOVE_THREADING_DETECTOR_LOCKS = SaturnOptions.createOption("removeThreadingDetectorLocks", "(default = true) Removes duplicated threading detector locks.", "miscellaneous.threading_detector", true);
    }
}

