/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.mixin;

import invoker54.reviveme.common.capability.FallenCapability;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.event.FallEvent;
import invoker54.reviveme.common.network.NetworkHandler;
import invoker54.reviveme.common.network.message.SyncClientCapMsg;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeHooks.class})
public class ForgeHooksMixin {
    @Inject(remap=false, method={"onInteractEntity(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onInteractEntity(Player player, Entity target, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (target.m_9236_().f_46443_) {
            return;
        }
        FallenCapability myCap = FallenCapability.GetFallCap((LivingEntity)player);
        if (myCap.isFallen()) {
            return;
        }
        if (player.m_20163_()) {
            return;
        }
        if (!(target instanceof Player)) {
            return;
        }
        Player targPlayer = (Player)target;
        FallenCapability targCap = FallenCapability.GetFallCap((LivingEntity)targPlayer);
        if (!targCap.isFallen() || targCap.getOtherPlayer() != null) {
            return;
        }
        if (!targCap.hasEnough(player)) {
            return;
        }
        targCap.setProgress(player.m_9236_().m_46467_(), ReviveMeConfig.reviveTime);
        targCap.setOtherPlayer(player.m_20148_());
        myCap.setProgress(player.m_9236_().m_46467_(), ReviveMeConfig.reviveTime);
        myCap.setOtherPlayer(targPlayer.m_20148_());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(player.m_20149_(), myCap.writeNBT());
        nbt.m_128365_(targPlayer.m_20149_(), targCap.writeNBT());
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> targPlayer), (Object)new SyncClientCapMsg((Tag)nbt));
        cir.setReturnValue((Object)InteractionResult.FAIL);
    }

    @Inject(remap=false, method={"onLivingDeath"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onLivingDeath(LivingEntity entity, DamageSource src, CallbackInfoReturnable<Boolean> cir) {
        boolean cancelled;
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        if (((ServerPlayer)entity).f_8941_.m_9290_() == GameType.CREATIVE) {
            return;
        }
        if (!FallenCapability.GetFallCap(entity).canDie()) {
            entity.m_21153_(1.0f);
            cancelled = true;
        } else if (ReviveMeConfig.runDeathEventFirst) {
            cancelled = MinecraftForge.EVENT_BUS.post((Event)new LivingDeathEvent(entity, src));
            if (!cancelled) {
                cancelled = FallEvent.cancelEvent((Player)entity, src);
            }
        } else {
            cancelled = FallEvent.cancelEvent((Player)entity, src);
            if (!cancelled) {
                cancelled = MinecraftForge.EVENT_BUS.post((Event)new LivingDeathEvent(entity, src));
            }
        }
        cir.setReturnValue((Object)cancelled);
    }
}

