/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.ElectricityTicker;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;

public interface IElectricityNode {
    public BlockPos getNodePosition();

    public Level getNodeLevel();

    public BlockEntity getNodeOwner();

    public AABB getNodeInteractBox();

    public boolean isSourceNode();

    public boolean isNodePowered();

    public void setNodePowered(boolean var1);

    public Set<Connection> getNodeConnections();

    public void setNodeReceivingPower(boolean var1);

    public Set<BlockPos> getPowerSources();

    default public boolean isNodeInPowerableNetwork() {
        return !this.getPowerSources().isEmpty();
    }

    default public boolean isNodeInPowerableNetwork(BlockPos source) {
        return this.getPowerSources().contains(source);
    }

    public boolean isNodeReceivingPower();

    default public boolean isNodeValid() {
        return !this.getNodeOwner().m_58901_();
    }

    default public void onNodeDestroyed() {
        this.removeAllNodeConnections();
    }

    default public void onNodeConnectedTo(IElectricityNode other) {
    }

    default public boolean canPowerTraverseNode() {
        return true;
    }

    default public Set<Connection> updateAndGetNodeConnections() {
        this.updateNodeConnections();
        return this.getNodeConnections();
    }

    default public void syncDataToTrackingClients() {
        BlockEntity entity = this.getNodeOwner();
        BlockEntityHelper.sendCustomUpdate(entity, entity.m_5995_());
    }

    default public void readNodeNbt(CompoundTag tag) {
        if (tag.m_128425_("Connections", 12)) {
            long[] nodes;
            BlockPos previous;
            BlockPos current;
            BlockPos offset = BlockPos.f_121853_;
            if (tag.m_128425_("NodePos", 4) && !(current = this.getNodePosition()).equals((Object)(previous = BlockPos.m_122022_((long)tag.m_128454_("NodePos"))))) {
                offset = current.m_121996_((Vec3i)previous);
            }
            BlockPos pos = this.getNodePosition();
            Set<Connection> connections = this.getNodeConnections();
            connections.clear();
            for (long node : nodes = tag.m_128467_("Connections")) {
                connections.add(Connection.of(pos, BlockPos.m_122022_((long)node).m_121955_((Vec3i)offset)));
            }
        }
    }

    default public void writeNodeNbt(CompoundTag tag) {
        Set<Connection> connections = this.getNodeConnections();
        tag.m_128428_("Connections", connections.stream().map(Connection::getPosB).map(BlockPos::m_121878_).toList());
        tag.m_128356_("NodePos", this.getNodePosition().m_121878_());
    }

    default public void saveNodeNbtToItem(ItemStack stack) {
        BlockEntity entity = this.getNodeOwner();
        CompoundTag tag = entity.m_187482_();
        tag.m_128473_("Connections");
        tag.m_128473_("NodePos");
        tag.m_128473_("Powered");
        tag.m_128473_("Overloaded");
        BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)entity.m_58903_(), (CompoundTag)tag);
    }

    default public void removeNodeConnection(Connection connection) {
        if (this.getNodeConnections().remove(connection)) {
            this.syncDataToTrackingClients();
            this.getNodeOwner().m_6596_();
        }
    }

    default public void removeAllNodeConnections() {
        Set<Connection> connections = this.getNodeConnections();
        connections.forEach(c -> {
            IElectricityNode node = c.getOtherNode(this);
            if (node != null) {
                node.removeNodeConnection((Connection)c);
                node.syncDataToTrackingClients();
            }
        });
        connections.clear();
        this.getNodeOwner().m_6596_();
    }

    default public void updateNodeConnections() {
        Level level = this.getNodeLevel();
        this.getNodeConnections().removeIf(c -> {
            if (!c.isConnected(level)) {
                IElectricityNode node = c.getNodeB(level);
                if (node != null) {
                    node.removeNodeConnection((Connection)c);
                }
                return true;
            }
            return false;
        });
    }

    default public int getNodeMaximumConnections() {
        return (Integer)Config.SERVER.electricity.maximumLinksPerElectricityNode.get();
    }

    default public boolean isNodeConnectionLimitReached() {
        return this.getNodeConnections().size() >= this.getNodeMaximumConnections();
    }

    default public boolean connectToNode(IElectricityNode other) {
        BlockPos pos = this.getNodePosition();
        Set<Connection> connections = this.getNodeConnections();
        if (connections.add(Connection.of(pos, other.getNodePosition()))) {
            other.connectToNode(this);
            this.onNodeConnectedTo(other);
            this.syncDataToTrackingClients();
            this.getNodeOwner().m_6596_();
            return true;
        }
        return false;
    }

    default public boolean isConnectedToNode(IElectricityNode node) {
        Set<Connection> connections = this.getNodeConnections();
        return connections.contains(Connection.of(this.getNodePosition(), node.getNodePosition()));
    }

    default public AABB getPositionedNodeInteractBox() {
        return this.getNodeInteractBox().m_82338_(this.getNodePosition());
    }

    default public void registerElectricityNodeTicker(Level level) {
        ElectricityTicker.get(level).addElectricityNode(this);
    }

    default public void earlyNodeTick(Level level) {
    }

    public static List<IElectricityNode> searchNodes(IElectricityNode start) {
        return IElectricityNode.searchNodes(start, (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get(), false, node -> true, node -> true);
    }

    public static List<IElectricityNode> searchNodes(IElectricityNode start, int searchLimit, boolean cancelAtLimit, Predicate<IElectricityNode> searchPredicate, Predicate<IElectricityNode> matchPredicate) {
        AABB box = ISourceNode.createPowerableZone(start.getNodeLevel(), start.getNodePosition());
        HashSet<IElectricityNode> found = new HashSet<IElectricityNode>(List.of(start));
        ArrayDeque<IElectricityNode> queue = new ArrayDeque<IElectricityNode>(searchLimit);
        queue.add(start);
        block0: while (!queue.isEmpty()) {
            IElectricityNode node = (IElectricityNode)queue.poll();
            for (Connection connection : node.getNodeConnections()) {
                BlockPos pos;
                IElectricityNode other = connection.getNodeB(node.getNodeLevel());
                if (other == null || found.contains(other) || !box.m_82393_((double)(pos = other.getNodePosition()).m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) continue;
                found.add(other);
                if (cancelAtLimit && found.size() >= searchLimit) break block0;
                if (!searchPredicate.test(other)) continue;
                queue.add(other);
            }
        }
        return found.stream().filter(matchPredicate).collect(Collectors.toList());
    }
}

