/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.resource.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.resource.manager.JsonDataManager;
import java.util.HashMap;
import java.util.Map;
import me.xjqsh.lrtactical.init.ModRegistries;
import me.xjqsh.lrtactical.item.index.MeleeWeaponIndex;
import me.xjqsh.lrtactical.item.melee.MeleeWeaponType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class MeleeIndexManager
extends JsonDataManager<MeleeWeaponIndex<?>> {
    private Map<ResourceLocation, String> networkCache = new HashMap<ResourceLocation, String>();

    public MeleeIndexManager(Gson pGson) {
        super(null, pGson, "index/melee", "MeleeWeaponIndex");
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.dataMap.clear();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonElement element = entry.getValue();
            if (!element.isJsonObject()) {
                GunMod.LOGGER.error(this.getMarker(), "Failed to load index file {}: Expected object, got {} ", (Object)id, (Object)element);
                continue;
            }
            JsonObject pJson = element.getAsJsonObject();
            try {
                MeleeWeaponIndex<?> index = MeleeIndexManager.parse(pJson, id);
                this.dataMap.put(id, index);
                builder.put((Object)id, (Object)pJson.toString());
            }
            catch (JsonParseException | IllegalArgumentException e) {
                GunMod.LOGGER.error(this.getMarker(), "Failed to load index file {}", (Object)id, (Object)e);
            }
        }
        this.networkCache = builder.build();
    }

    public Map<ResourceLocation, String> getCache() {
        return this.networkCache;
    }

    public static MeleeWeaponIndex<?> parse(JsonObject pJson, ResourceLocation id) throws JsonParseException {
        String name = GsonHelper.m_13851_((JsonObject)pJson, (String)"name", (String)"unknown.lrtactical.name");
        String tooltip = GsonHelper.m_13851_((JsonObject)pJson, (String)"tooltip", null);
        String type_name = GsonHelper.m_13851_((JsonObject)pJson, (String)"type", (String)"lrtactical:normal");
        MeleeWeaponType type = (MeleeWeaponType)ModRegistries.MELEE_WEAPON_TYPE_SUPPLIER.get().getValue(new ResourceLocation(type_name));
        if (type == null) {
            throw new JsonParseException("Unknown type name \"" + type_name + "\"");
        }
        String baseItem = GsonHelper.m_13851_((JsonObject)pJson, (String)"base_item", (String)"lrtactical:melee");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(baseItem));
        if (item == null) {
            throw new JsonParseException("Unknown item id \"" + type_name + "\"");
        }
        JsonObject data = GsonHelper.m_13930_((JsonObject)pJson, (String)"data");
        return MeleeWeaponIndex.deserialize(type, (JsonElement)data, name, tooltip, id, item);
    }
}

