/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.entity;

import java.util.List;
import me.xjqsh.lrtactical.entity.ThrowableItemEntity;
import me.xjqsh.lrtactical.entity.sp.SpEffectCloudEntity;
import me.xjqsh.lrtactical.item.throwable.area.EffectCloudThrowableData;
import me.xjqsh.lrtactical.network.NetworkHandler;
import me.xjqsh.lrtactical.network.message.SSplashParticle;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.Nullable;

public class EffectCloudGrenadeEntity
extends ThrowableItemEntity {
    public static EntityType<EffectCloudGrenadeEntity> TYPE = EntityType.Builder.m_20704_(EffectCloudGrenadeEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).setCustomClientFactory(EffectCloudGrenadeEntity::new).m_20699_(0.3f, 0.3f).m_20716_().m_20698_().m_20719_().m_20712_("grenade_entity");
    private EffectCloudThrowableData.CloudData cloudData;

    public EffectCloudGrenadeEntity(LivingEntity entity, Level level, int lifeTime) {
        super(TYPE, entity, level, lifeTime);
    }

    public EffectCloudGrenadeEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        super(TYPE, level);
    }

    public EffectCloudGrenadeEntity(EntityType<EffectCloudGrenadeEntity> type, Level level) {
        super(type, level);
    }

    @Override
    public void onDeath(@Nullable HitResult hitResult) {
        Vec3 pos;
        Vec3 vec3 = pos = hitResult == null ? this.m_20182_() : hitResult.m_82450_();
        if (!this.m_9236_().m_5776_() && this.cloudData != null) {
            EffectCloudThrowableData.CloudData cloudData = this.getCloudData();
            if (cloudData.isAreaCloud()) {
                this.spawnEffectCloud(pos, cloudData);
            } else {
                Entity entity;
                List<MobEffectInstance> effects = cloudData.getEffectInstances();
                if (hitResult instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                    entity = entityHitResult.m_82443_();
                } else {
                    entity = null;
                }
                Entity target = entity;
                int color = PotionUtils.m_43564_(effects);
                this.applySplash(effects, cloudData.isIgnite(), cloudData.getIgniteTime(), target, cloudData.getRadius());
                NetworkHandler.sendToNearbyPlayers(new SSplashParticle(this.m_20183_(), color), this.m_9236_(), pos, 64.0);
            }
        }
        super.onDeath(hitResult);
    }

    private void spawnEffectCloud(Vec3 pos, EffectCloudThrowableData.CloudData cloudData) {
        SpEffectCloudEntity cloud = new SpEffectCloudEntity(this.m_9236_(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        cloud.m_19712_(cloudData.getRadius());
        cloud.m_19738_(cloudData.getRadiusPerTick());
        cloud.m_19734_(cloudData.getDuration());
        cloud.m_19740_(cloudData.getWaitTime());
        cloud.m_19724_(cloudData.getParticles());
        cloud.setIgnite(cloudData.isIgnite());
        cloud.setExtinguishBySmoke(cloudData.isExtinguishBySmoke());
        for (EffectCloudThrowableData.EffectData effect : cloudData.getEffects()) {
            cloud.m_19716_(effect.toInstance());
        }
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            cloud.m_19718_(livingEntity);
        }
        this.m_9236_().m_7967_((Entity)cloud);
    }

    public void applySplash(List<MobEffectInstance> effectInstances, boolean ignite, int igniteTime, @Nullable Entity target, double radius) {
        if (effectInstances.isEmpty() || radius <= 0.0) {
            return;
        }
        AABB area = this.m_20191_().m_82377_(radius, 2.0, radius);
        List entities = this.m_9236_().m_45976_(LivingEntity.class, area);
        if (!entities.isEmpty()) {
            Entity source = this.m_150173_();
            for (LivingEntity entity : entities) {
                double distanceSqr;
                if (!entity.m_5801_() || !((distanceSqr = this.m_20280_((Entity)entity)) < 16.0)) continue;
                double d = entity == target ? 1.0 : 1.0 - Math.sqrt(distanceSqr) / radius;
                this.applyAllEffects(effectInstances, entity, d, source, ignite, igniteTime);
            }
        }
    }

    public void applyAllEffects(List<MobEffectInstance> effectInstances, LivingEntity entity, double d, Entity source, boolean ignite, int igniteTime) {
        for (MobEffectInstance effect : effectInstances) {
            MobEffect mobEffect = effect.m_19544_();
            if (mobEffect.m_8093_()) {
                mobEffect.m_19461_((Entity)this, this.m_19749_(), entity, effect.m_19564_(), d);
                continue;
            }
            int adjustedDuration = effect.m_267696_(duration -> (int)(d * (double)duration + 0.5));
            MobEffectInstance adjustedEffect = new MobEffectInstance(mobEffect, adjustedDuration, effect.m_19564_(), effect.m_19571_(), effect.m_19572_());
            if (adjustedEffect.m_267633_(20)) continue;
            entity.m_147207_(adjustedEffect, source);
        }
        if (ignite && !entity.m_5825_()) {
            entity.m_20254_(igniteTime);
        }
    }

    public EffectCloudThrowableData.CloudData getCloudData() {
        return this.cloudData;
    }

    public void setCloudData(EffectCloudThrowableData.CloudData cloudData) {
        this.cloudData = cloudData;
    }
}

