/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.client.renderer.item;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tacz.guns.api.client.animation.AnimationController;
import com.tacz.guns.api.client.animation.AnimationListenerSupplier;
import com.tacz.guns.api.client.animation.Animations;
import com.tacz.guns.api.client.animation.statemachine.LuaStateMachineFactory;
import com.tacz.guns.api.client.event.BeforeRenderHandEvent;
import com.tacz.guns.client.model.BedrockAnimatedModel;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.model.functional.LeftHandRender;
import com.tacz.guns.client.model.functional.RightHandRender;
import com.tacz.guns.client.renderer.item.AnimateGeoItemRenderer;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.animation.bedrock.BedrockAnimationFile;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import me.xjqsh.lrtactical.api.animation.FlashShieldAnimationStateContext;
import me.xjqsh.lrtactical.client.resource.LrClientAssetsManager;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.luaj.vm2.LuaTable;

public class FlashShieldItemRenderer
extends AnimateGeoItemRenderer<BedrockAnimatedModel, FlashShieldAnimationStateContext> {
    private static final SlotModel SLOT_MODEL = new SlotModel();
    private ItemTransforms transforms = ItemTransforms.f_111786_;
    private ResourceLocation slotTexture = null;

    public FlashShieldAnimationStateContext initContext(ItemStack stack, Player player, float partialTick) {
        FlashShieldAnimationStateContext context = new FlashShieldAnimationStateContext();
        this.updateContext(context, stack, player, partialTick);
        return context;
    }

    public void updateContext(FlashShieldAnimationStateContext context, ItemStack stack, Player player, float partialTick) {
        context.setPartialTicks(partialTick);
        context.setUsing(player.m_6117_());
        context.setUsingTick(player.m_21252_());
        context.setPartialTicks(partialTick);
        context.setCurrentItem(stack);
    }

    public long getPutAwayTime(ItemStack stack) {
        return 320L;
    }

    public void applyItemInHandCameraAnimation(BeforeRenderHandEvent event, ItemStack stack, float multiplier) {
        super.applyItemInHandCameraAnimation(event, stack, multiplier);
        this.model.cleanCameraAnimationTransform();
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext ctx, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        if (ctx.m_269069_()) {
            return;
        }
        if (ctx == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            return;
        }
        if (ctx == ItemDisplayContext.GUI && this.slotTexture != null) {
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.slotTexture));
            SLOT_MODEL.m_7695_(poseStack, buffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        poseStack.m_85836_();
        if (this.transforms != null) {
            poseStack.m_252880_(0.5f, 0.5f, 0.5f);
            ItemTransform transform = this.transforms.m_269404_(ctx);
            transform.m_111763_(false, poseStack);
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        }
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        if (this.model != null) {
            this.model.render(poseStack, ctx, RenderType.m_110452_((ResourceLocation)this.getTextureLocation(stack)), light, overlay);
        } else {
            VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)MissingTextureAtlasSprite.m_118071_()));
            SLOT_MODEL.m_7695_(poseStack, buffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }

    public void init(ShieldDisplay display) {
        BedrockModelPOJO modelPOJO = ClientAssetsManager.INSTANCE.getBedrockModelPOJO(display.modelLocation);
        this.model = new BedrockAnimatedModel(modelPOJO, BedrockVersion.NEW);
        this.model.setFunctionalRenderer("lefthand_pos", bedrockPart -> new LeftHandRender(this.model));
        this.model.setFunctionalRenderer("righthand_pos", bedrockPart -> new RightHandRender(this.model));
        this.textureLocation = new ResourceLocation(display.textureLocation.m_135827_(), "textures/" + display.textureLocation.m_135815_() + ".png");
        if (display.slotTextureLocation != null) {
            this.slotTexture = new ResourceLocation(display.slotTextureLocation.m_135827_(), "textures/" + display.slotTextureLocation.m_135815_() + ".png");
        }
        this.transforms = display.transforms == null ? ItemTransforms.f_111786_ : display.transforms;
        BedrockAnimationFile animation = ClientAssetsManager.INSTANCE.getBedrockAnimations(display.animationLocation);
        AnimationController controller = null;
        if (animation != null) {
            controller = Animations.createControllerFromBedrock((BedrockAnimationFile)animation, (AnimationListenerSupplier)this.model);
        }
        LuaTable script = ClientAssetsManager.INSTANCE.getScript(display.stateMachineLocation);
        this.stateMachine = new LuaStateMachineFactory().setController(controller).setLuaScripts(script).build();
    }

    public void m_6213_(ResourceManager manager) {
        manager.m_213713_(new ResourceLocation("lrtactical", "display/shield/flash_shield.json")).map(resource -> {
            ShieldDisplay shieldDisplay;
            block8: {
                InputStream stream = resource.m_215507_();
                try {
                    shieldDisplay = (ShieldDisplay)LrClientAssetsManager.GSON.fromJson((Reader)new InputStreamReader(stream), ShieldDisplay.class);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                stream.close();
            }
            return shieldDisplay;
        }).ifPresent(this::init);
    }

    public record ShieldDisplay(@SerializedName(value="model") ResourceLocation modelLocation, @SerializedName(value="animation") ResourceLocation animationLocation, @SerializedName(value="state_machine") ResourceLocation stateMachineLocation, @SerializedName(value="texture") ResourceLocation textureLocation, @SerializedName(value="slot_texture") ResourceLocation slotTextureLocation, @SerializedName(value="transforms") ItemTransforms transforms) {
    }
}

