/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.api.collision;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import me.xjqsh.lrtactical.api.collision.ITargetFilter;
import me.xjqsh.lrtactical.api.collision.OBB;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class OBBFilter
implements ITargetFilter {
    @SerializedName(value="max_range")
    private double maxRange = 4.0;
    @SerializedName(value="half_width")
    private double halfWidth = 0.5;
    @SerializedName(value="half_height")
    private double halfHeight = 0.5;
    @SerializedName(value="exclude_self")
    private boolean excludeSelf = true;
    @SerializedName(value="roll")
    private float roll = 0.0f;

    @Override
    @NotNull
    public List<Entity> filterTargets(LivingEntity attacker, Vec3 origin, Vec3 direction) {
        Quaternionf rotation = new Quaternionf().rotationYXZ(-attacker.m_146908_() * ((float)Math.PI / 180), attacker.m_146909_() * ((float)Math.PI / 180), this.roll * ((float)Math.PI / 180));
        Vector3f extents = new Vec3(this.halfWidth, this.halfHeight, this.maxRange / 2.0).m_252839_();
        Vector3f center = origin.m_82549_(direction.m_82490_(this.maxRange / 2.0)).m_252839_();
        OBB obb = new OBB(center, extents, rotation);
        ArrayList<Entity> targets = new ArrayList<Entity>();
        AABB area = attacker.m_20191_().m_82377_(this.maxRange * 2.0, this.maxRange, this.maxRange * 2.0);
        for (Entity livingentity : attacker.m_9236_().m_45976_(Entity.class, area)) {
            ArmorStand armorStand;
            boolean flag = !(livingentity instanceof ArmorStand) || !(armorStand = (ArmorStand)livingentity).m_31677_();
            boolean see = ITargetFilter.hasLineOfSight(attacker, livingentity);
            boolean self = this.excludeSelf && livingentity == attacker;
            if (self || !flag || !obb.interactsWithAABB(livingentity.m_20191_()) || !see) continue;
            targets.add(livingentity);
        }
        return targets;
    }

    @Override
    public double getMaxRange() {
        return this.maxRange;
    }
}

