/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.client.util;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import invoker54.invocore.client.util.ClientUtil;
import invoker54.invocore.client.util.InvoZone;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import org.joml.Matrix4f;

public class TextUtil {
    private static int black = new Color(0, 0, 0, 255).getRGB();
    private static CharacterManagerMixer characterMixer;

    public static void renderText(PoseStack stack, Component text, boolean shadow, float x0, float maxWidth, float y0, float maxHeight, int padding, txtAlignment align) {
        TextUtil.renderText(stack, text, shadow, 0, x0, maxWidth, y0, maxHeight, padding, align);
    }

    public static void renderText(PoseStack stack, Component text, boolean shadow, int maxSplits, InvoZone renderZone, txtAlignment alignment) {
        TextUtil.renderText(stack, text, shadow, maxSplits, renderZone.x(), renderZone.width(), renderZone.y(), renderZone.height(), 0, alignment);
    }

    public static void renderText(PoseStack stack, Component text, boolean shadow, int maxSplits, float x0, float maxWidth, float y0, float maxHeight, int padding, txtAlignment align) {
        if (characterMixer == null) {
            characterMixer = new CharacterManagerMixer();
        }
        ArrayList<FormattedText> list = new ArrayList<FormattedText>();
        int txtWidth = ClientUtil.getFont().m_92852_((FormattedText)text);
        if (maxSplits != 1) {
            double spaceRatio = maxWidth / maxHeight;
            double textArea = 9 * txtWidth;
            double multiplier = textArea / ((spaceRatio *= 9.0) * 9.0);
            multiplier = Math.sqrt(multiplier);
            double cutoffPoint = Math.ceil(multiplier * spaceRatio);
            double neededSplits = (double)txtWidth / cutoffPoint;
            if (maxSplits != 0 && (neededSplits > (double)maxSplits || maxSplits < 0 && (double)Math.abs(maxSplits) > Math.ceil(neededSplits))) {
                neededSplits = Math.abs(maxSplits);
            }
            characterMixer.m_92393_((FormattedText)text, (int)((double)ClientUtil.getFont().m_92852_((FormattedText)text) / neededSplits), Style.f_131099_, (A, B) -> list.add((FormattedText)A));
        } else {
            list.add((FormattedText)text);
        }
        TextUtil.renderText(stack, list, shadow, x0, maxWidth, y0, maxHeight, padding, align);
    }

    public static void renderText(PoseStack stack, List<FormattedText> textLines, boolean shadow, InvoZone renderZone, txtAlignment alignment) {
        TextUtil.renderText(stack, textLines, shadow, renderZone.x(), renderZone.width(), renderZone.y(), renderZone.height(), 0, alignment);
    }

    public static void renderText(PoseStack stack, List<FormattedText> textLines, boolean shadow, float x0, float maxWidth, float y0, float maxHeight, int padding, txtAlignment align) {
        Font font = ClientUtil.getFont();
        stack.m_85836_();
        float maxTxtHeight = textLines.size() * 8;
        maxTxtHeight += (float)(-2 + textLines.size());
        float maxTxtWidth = 0.0f;
        FormattedText largestComponent = textLines.get(0);
        for (FormattedText textComponent : textLines) {
            int currentWidth = font.m_92852_(textComponent);
            if (!((float)currentWidth > maxTxtWidth)) continue;
            maxTxtWidth = currentWidth;
            largestComponent = textComponent;
        }
        maxTxtWidth -= 1.0f;
        float shadowOffset = 0.0f;
        if (shadow) {
            shadowOffset = 1.0f;
            maxTxtHeight += shadowOffset;
            maxTxtWidth += shadowOffset;
        }
        float heightFillAmount = maxHeight / maxTxtHeight;
        float widthFillAmount = maxWidth / maxTxtWidth;
        float scaleFactor = 0.0f;
        if (heightFillAmount < widthFillAmount || heightFillAmount == widthFillAmount) {
            scaleFactor = (maxHeight - (float)(align == txtAlignment.MIDDLE ? padding * 2 : padding)) / maxTxtHeight;
        } else if (heightFillAmount > widthFillAmount) {
            scaleFactor = (maxWidth - (float)(align == txtAlignment.MIDDLE ? padding * 2 : padding)) / maxTxtWidth;
        }
        stack.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        for (int a = 0; a < textLines.size(); ++a) {
            FormattedText currText = textLines.get(a);
            float y = y0 / scaleFactor;
            float f = (maxHeight - maxTxtHeight * scaleFactor) / 2.0f;
            Objects.requireNonNull(font);
            y += (f + (float)(a * 9) * scaleFactor) / scaleFactor;
            float x = x0;
            switch (align) {
                case LEFT: {
                    x /= scaleFactor;
                    break;
                }
                case MIDDLE: {
                    x = (x + (maxWidth - ((float)font.m_92852_(currText) - (1.0f - shadowOffset)) * scaleFactor) / 2.0f) / scaleFactor;
                    break;
                }
                case RIGHT: {
                    x = (x + maxWidth) / scaleFactor - ((float)padding + ((float)font.m_92852_(currText) - (1.0f - shadowOffset)) * scaleFactor) / scaleFactor;
                }
            }
            TextUtil.renderText(currText, stack, x, y, shadow);
        }
        stack.m_85849_();
    }

    public static void renderText(FormattedText text, PoseStack stack, float x, float y, boolean shadow) {
        MultiBufferSource.BufferSource irendertypebuffer$impl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int i = "deadmau5".equals(text.getString()) ? -10 : 0;
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        int lightCoords = 0xF000F0;
        boolean j = false;
        Font fontrenderer = ClientUtil.getFont();
        RenderSystem.disableDepthTest();
        fontrenderer.m_272191_(Language.m_128107_().m_5536_(text), x, y, -1, shadow, matrix4f, (MultiBufferSource)irendertypebuffer$impl, Font.DisplayMode.SEE_THROUGH, 0, lightCoords);
        irendertypebuffer$impl.m_109911_();
        RenderSystem.enableDepthTest();
    }

    public static enum txtAlignment {
        LEFT,
        MIDDLE,
        RIGHT;

    }

    public static class CharacterManagerMixer
    extends StringSplitter {
        public CharacterManagerMixer() {
            super(ClientUtil.getFont().m_92865_().f_92333_);
        }

        public void m_92393_(FormattedText text, int cutoffPoint, Style p_style, BiConsumer<FormattedText, Boolean> splitifier) {
            ArrayList list = Lists.newArrayList();
            text.m_7451_((p_238355_1_, p_238355_2_) -> {
                if (!p_238355_2_.isEmpty()) {
                    StringSplitter.LineComponent textComponent = new StringSplitter.LineComponent(p_238355_2_, p_238355_1_);
                    list.add(textComponent);
                }
                return Optional.empty();
            }, p_style);
            StringSplitter.FlatComponents charactermanager$substyledtext = new StringSplitter.FlatComponents((List)list);
            boolean complete = false;
            boolean flag1 = false;
            boolean keepGoing = false;
            float averagePoint = cutoffPoint;
            int count = 1;
            while (!complete) {
                complete = true;
                MultilineProcessorMixer multilineProcessor = new MultilineProcessorMixer(cutoffPoint);
                for (StringSplitter.LineComponent charactermanager$styleoverridingtextcomponent : charactermanager$substyledtext.f_92445_) {
                    boolean flag3 = StringDecomposer.m_14311_((String)charactermanager$styleoverridingtextcomponent.f_92485_, (int)0, (Style)charactermanager$styleoverridingtextcomponent.f_92486_, (Style)p_style, (FormattedCharSink)multilineProcessor);
                    if (!flag3) {
                        int i = multilineProcessor.getSplitPosition();
                        Style style = multilineProcessor.getSplitStyle();
                        char c0 = charactermanager$substyledtext.m_92450_(i);
                        boolean shouldReturn = c0 == '\n';
                        boolean shouldBreak = shouldReturn || c0 == ' ';
                        flag1 = shouldReturn;
                        FormattedText FormattedText2 = charactermanager$substyledtext.m_92452_(i, shouldBreak ? 1 : 0, style);
                        splitifier.accept(FormattedText2, keepGoing);
                        keepGoing = !shouldReturn;
                        complete = false;
                        break;
                    }
                    multilineProcessor.addToOffset(charactermanager$styleoverridingtextcomponent.f_92485_.length());
                }
                averagePoint += multilineProcessor.getWidth();
                ++count;
            }
            FormattedText FormattedText1 = charactermanager$substyledtext.m_92449_();
            if (FormattedText1 != null) {
                splitifier.accept(FormattedText1, keepGoing);
            } else if (flag1) {
                splitifier.accept(FormattedText.f_130760_, false);
            }
        }

        public class MultilineProcessorMixer
        implements FormattedCharSink {
            private final float maxWidth;
            private int lineBreak = -1;
            private Style lineBreakStyle = Style.f_131099_;
            private boolean hadNonZeroWidthChar;
            private float width;
            private int lastSpace = -1;
            private Style lastSpaceStyle = Style.f_131099_;
            private int nextChar;
            private int offset;
            private boolean hasWord = false;
            private boolean wordCaptured = false;
            private float baseShot = 0.0f;
            private int baseSpace = -1;
            private float baseWidth = 0.0f;
            private Style baseStyle;
            private float overShot = 0.0f;

            public MultilineProcessorMixer(float maxWidth) {
                this.maxWidth = Math.max(maxWidth, 1.0f);
            }

            public boolean m_6411_(int length, Style style, int codeNumber) {
                int lvt_4_1_ = length + this.offset;
                boolean isSpace = false;
                switch (codeNumber) {
                    case 10: {
                        return this.finishIteration(lvt_4_1_, style);
                    }
                    case 32: {
                        this.baseSpace = this.lastSpace;
                        this.baseStyle = this.lastSpaceStyle;
                        this.baseWidth = this.getWidth();
                        this.lastSpace = lvt_4_1_;
                        this.lastSpaceStyle = style;
                        isSpace = true;
                        if (this.width < this.maxWidth || !this.wordCaptured) {
                            this.baseShot = 0.0f;
                            this.overShot = 0.0f;
                        }
                        if (!this.hasWord) break;
                        this.wordCaptured = true;
                    }
                }
                float lvt_5_1_ = CharacterManagerMixer.this.f_92333_.m_92515_(codeNumber, style);
                if (!isSpace) {
                    this.hasWord = true;
                    if (this.width < this.maxWidth) {
                        this.baseShot += lvt_5_1_;
                    } else {
                        this.overShot += lvt_5_1_;
                    }
                }
                this.width += lvt_5_1_;
                if (this.hadNonZeroWidthChar && this.width >= this.maxWidth && isSpace && this.wordCaptured) {
                    this.width -= lvt_5_1_;
                    if (this.baseShot < this.overShot) {
                        this.lastSpace = this.baseSpace;
                        this.lastSpaceStyle = this.baseStyle;
                        this.width = this.baseWidth;
                    }
                    return this.finishIteration(this.lastSpace, this.lastSpaceStyle);
                }
                this.hadNonZeroWidthChar |= lvt_5_1_ != 0.0f;
                this.nextChar = lvt_4_1_ + Character.charCount(codeNumber);
                return true;
            }

            private boolean finishIteration(int p_238388_1_, Style p_238388_2_) {
                this.lineBreak = p_238388_1_;
                this.lineBreakStyle = p_238388_2_;
                return false;
            }

            private boolean lineBreakFound() {
                return this.lineBreak != -1;
            }

            public int getSplitPosition() {
                return this.lineBreakFound() ? this.lineBreak : this.nextChar;
            }

            public Style getSplitStyle() {
                return this.lineBreakStyle;
            }

            public void addToOffset(int p_238387_1_) {
                this.offset += p_238387_1_;
            }

            public float getWidth() {
                return this.width;
            }
        }
    }
}

