/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import invoker54.invocore.client.Ticker;
import invoker54.invocore.client.util.InvoZone;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

public class ClientUtil {
    private static Minecraft mC;
    public static final DecimalFormat d1;
    private static final Logger LOGGER;
    protected static final ArrayList<Bounds> cropBounds;

    public static Font getFont() {
        return ClientUtil.getMinecraft().f_91062_;
    }

    public static Minecraft getMinecraft() {
        if (mC == null) {
            mC = Minecraft.m_91087_();
        }
        return mC;
    }

    public static Player getPlayer() {
        return ClientUtil.getMinecraft().f_91074_;
    }

    public static Level getWorld() {
        return ClientUtil.getMinecraft().f_91073_;
    }

    public static void drawWorldLine(PoseStack stack, Vec3 origin, Vec3 target, float lineWidth, int color) {
        stack.m_85836_();
        Vec3 cam = ClientUtil.getMinecraft().f_91063_.m_109153_().m_90583_().m_82548_();
        stack.m_85837_(cam.m_7096_(), cam.m_7098_(), cam.m_7094_());
        cam = cam.m_82548_();
        Matrix4f lastPos = stack.m_85850_().m_252922_();
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Vec3 directionVector = target.m_82505_(cam).m_82537_(origin.m_82505_(cam)).m_82541_();
        Vec3 originUP = origin.m_82549_(directionVector.m_82490_((double)(lineWidth / 2.0f)));
        Vec3 originDOWN = origin.m_82549_(directionVector.m_82490_((double)(-lineWidth / 2.0f)));
        Vec3 targetUP = target.m_82549_(directionVector.m_82490_((double)(lineWidth / 2.0f)));
        Vec3 targetDOWN = target.m_82549_(directionVector.m_82490_((double)(-lineWidth / 2.0f)));
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(lastPos, (float)originUP.m_7096_(), (float)originUP.m_7098_(), (float)originUP.m_7094_()).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(lastPos, (float)targetUP.m_7096_(), (float)targetUP.m_7098_(), (float)targetUP.m_7094_()).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(lastPos, (float)targetDOWN.m_7096_(), (float)targetDOWN.m_7098_(), (float)targetDOWN.m_7094_()).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(lastPos, (float)originDOWN.m_7096_(), (float)originDOWN.m_7098_(), (float)originDOWN.m_7094_()).m_85950_(f, f1, f2, f3).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        stack.m_85849_();
    }

    public static void drawWorldLine(PoseStack stack, Vec3 origin, Vec3 target, float lineWidth, float u0, float imageWidth, float v0, float imageHeight, float imageScale) {
        stack.m_85836_();
        Vec3 cam = ClientUtil.getMinecraft().f_91063_.m_109153_().m_90583_().m_82548_();
        stack.m_85837_(cam.m_7096_(), cam.m_7098_(), cam.m_7094_());
        cam = cam.m_82548_();
        Matrix4f lastPos = stack.m_85850_().m_252922_();
        float u1 = (u0 /= imageScale) + imageWidth / imageScale;
        float v1 = (v0 /= imageScale) + imageHeight / imageScale;
        Vec3 directionVector = target.m_82505_(cam).m_82537_(origin.m_82505_(cam)).m_82541_();
        Vec3 originUP = origin.m_82549_(directionVector.m_82490_((double)(lineWidth / 2.0f)));
        Vec3 originDOWN = origin.m_82549_(directionVector.m_82490_((double)(-lineWidth / 2.0f)));
        Vec3 targetUP = target.m_82549_(directionVector.m_82490_((double)(lineWidth / 2.0f)));
        Vec3 targetDOWN = target.m_82549_(directionVector.m_82490_((double)(-lineWidth / 2.0f)));
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(lastPos, (float)originUP.m_7096_(), (float)originUP.m_7098_(), (float)originUP.m_7094_()).m_7421_(u0, v0).m_5752_();
        bufferbuilder.m_252986_(lastPos, (float)targetUP.m_7096_(), (float)targetUP.m_7098_(), (float)targetUP.m_7094_()).m_7421_(u1, v0).m_5752_();
        bufferbuilder.m_252986_(lastPos, (float)targetDOWN.m_7096_(), (float)targetDOWN.m_7098_(), (float)targetDOWN.m_7094_()).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_252986_(lastPos, (float)originDOWN.m_7096_(), (float)originDOWN.m_7098_(), (float)originDOWN.m_7094_()).m_7421_(u0, v1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        stack.m_85849_();
    }

    public static void blitImage(PoseStack stack, InvoZone renderZone, InvoZone imageZone, float imageScale) {
        ClientUtil.blitImage(stack, renderZone.x(), renderZone.width(), renderZone.y(), renderZone.height(), imageZone.x(), imageZone.width(), imageZone.y(), imageZone.height(), imageScale);
    }

    public static void blitImage(PoseStack stack, float x0, float width, float y0, float height, float u0, float imageWidth, float v0, float imageHeight, float imageScale) {
        Matrix4f lastPos = stack.m_85850_().m_252922_();
        float x1 = x0 + width;
        float y1 = y0 + height;
        float u1 = (u0 /= imageScale) + imageWidth / imageScale;
        float v1 = (v0 /= imageScale) + imageHeight / imageScale;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(lastPos, x0, y1, 0.0f).m_7421_(u0, v1).m_5752_();
        bufferbuilder.m_252986_(lastPos, x1, y1, 0.0f).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_252986_(lastPos, x1, y0, 0.0f).m_7421_(u1, v0).m_5752_();
        bufferbuilder.m_252986_(lastPos, x0, y0, 0.0f).m_7421_(u0, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.enableDepthTest();
    }

    public static void blitColor(PoseStack stack, InvoZone renderZone, int color) {
        ClientUtil.blitColor(stack, renderZone.x(), renderZone.width(), renderZone.y(), renderZone.height(), color);
    }

    public static void blitColor(PoseStack stack, float x0, float width, float y0, float height, int color) {
        Matrix4f lastPos = stack.m_85850_().m_252922_();
        float x1 = x0 + width;
        float y1 = y0 + height;
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(lastPos, x0, y1, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(lastPos, x1, y1, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(lastPos, x1, y0, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(lastPos, x0, y0, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    public static void blitItem(PoseStack stack, InvoZone renderZone, ItemStack itemStack) {
        ClientUtil.blitItem(stack, renderZone.x(), renderZone.width(), renderZone.y(), renderZone.height(), itemStack);
    }

    public static void blitItem(PoseStack stack, float x0, float width, float y0, float height, ItemStack itemStack) {
        boolean flag;
        ClientUtil.getTextureManager().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        Lighting.m_84930_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        ItemRenderer renderer = ClientUtil.getMinecraft().m_91291_();
        BakedModel bakedModel = renderer.m_174264_(itemStack, null, null, 0);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_85837_((double)x0, (double)y0, 300.0);
        posestack.m_85837_((double)(width / 2.0f), (double)(height / 2.0f), 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(width, height, 16.0f);
        RenderSystem.applyModelViewMatrix();
        boolean bl = flag = !bakedModel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        } else {
            Lighting.m_84931_();
        }
        renderer.m_115143_(itemStack, ItemDisplayContext.GUI, false, stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
    }

    public static Vec3 smoothLerp(Vec3 oldPos, Vec3 newPos, boolean useDelta) {
        return new Vec3(ClientUtil.smoothLerp(oldPos.f_82479_, newPos.f_82479_, useDelta), ClientUtil.smoothLerp(oldPos.f_82480_, newPos.f_82480_, useDelta), ClientUtil.smoothLerp(oldPos.f_82481_, newPos.f_82481_, useDelta));
    }

    public static double smoothLerp(double oldDouble, double newDouble, boolean useDelta) {
        return Mth.m_14139_((double)(useDelta ? (double)Ticker.getDelta(true, true) : (double)ClientUtil.getMinecraft().m_91296_()), (double)oldDouble, (double)newDouble);
    }

    public static void copyEntityMovement(LivingEntity copier, LivingEntity toCopy) {
        copier.m_20219_(toCopy.m_20182_());
        copier.f_19854_ = toCopy.f_19854_;
        copier.f_19790_ = toCopy.f_19790_;
        copier.f_19855_ = toCopy.f_19855_;
        copier.f_19791_ = toCopy.f_19791_;
        copier.f_19856_ = toCopy.f_19856_;
        copier.f_19792_ = toCopy.f_19792_;
        copier.m_20256_(toCopy.m_20184_());
        copier.m_5616_(toCopy.m_6080_());
        copier.f_20886_ = toCopy.f_20886_;
        copier.m_5618_(toCopy.f_20883_);
        copier.f_20884_ = toCopy.f_20884_;
    }

    public static boolean inBounds(float xSpot, float ySpot, Bounds bounds) {
        if (xSpot < (float)bounds.x0 || xSpot > (float)bounds.x1) {
            return false;
        }
        return !(ySpot < (float)bounds.y0) && !(ySpot > (float)bounds.y1);
    }

    public static void beginCrop(double x, double width, double y, double height, boolean fresh) {
        if (fresh) {
            cropBounds.add(new Bounds((int)x, (int)width, (int)y, (int)height));
        }
        double scale = ClientUtil.getMinecraft().m_91268_().m_85449_();
        int windowHeight = ClientUtil.getMinecraft().m_91268_().m_85446_();
        y = (double)windowHeight - (height + y);
        RenderSystem.enableScissor((int)((int)(x *= scale)), (int)((int)(y *= scale)), (int)((int)(width *= scale)), (int)((int)(height *= scale)));
    }

    public static void endCrop() {
        if (cropBounds.size() != 0) {
            cropBounds.remove(cropBounds.size() - 1);
        }
        if (!cropBounds.isEmpty()) {
            Bounds cropBound = cropBounds.get(cropBounds.size() - 1);
            ClientUtil.beginCrop(cropBound.x0, cropBound.x1 - cropBound.x0, cropBound.y0, cropBound.y1 - cropBound.y0, false);
        } else {
            RenderSystem.disableScissor();
        }
    }

    public static String ticksToTime(int ticks) {
        int hours = ticks / 72000;
        int minutes = (ticks -= hours * 7200) / 1200;
        int seconds = (ticks -= minutes * 1200) / 20;
        return (hours <= 9 ? "0" : "") + hours + ":" + (minutes <= 9 ? "0" : "") + minutes + ":" + (seconds <= 9 ? "0" : "") + seconds;
    }

    public static String formatValue(double value) {
        if (value == 0.0) {
            return "0";
        }
        String suffix = " KMBT";
        Object formattedNumber = "";
        DecimalFormat formatter = new DecimalFormat("#,###.#");
        int power = (int)StrictMath.log10(value);
        formattedNumber = formatter.format(value /= Math.pow(10.0, power / 3 * 3));
        return ((String)(formattedNumber = (String)formattedNumber + suffix.charAt(power / 3))).length() > 4 ? ((String)formattedNumber).replaceAll("\\.[0-9]+ ", "") : formattedNumber;
    }

    public static TextureManager getTextureManager() {
        return mC.m_91097_();
    }

    static {
        d1 = new DecimalFormat("0.0");
        LOGGER = LogManager.getLogger();
        cropBounds = new ArrayList();
    }

    public static class Bounds {
        int x0;
        int x1;
        int y0;
        int y1;

        public Bounds(int x, int width, int y, int height) {
            this.x0 = x;
            this.x1 = x + width;
            this.y0 = y;
            this.y1 = y + height;
        }

        public Bounds() {
        }

        public void adjustBounds(int x, int width, int y, int height) {
            this.x0 = x;
            this.x1 = x + width;
            this.y0 = y;
            this.y1 = y + height;
        }

        public int getMinX() {
            return this.x0;
        }

        public int getMaxX() {
            return this.x1;
        }

        public int getMinY() {
            return this.y0;
        }

        public int getMaxY() {
            return this.y1;
        }
    }

    public static class Image {
        protected ResourceLocation location;
        protected final InvoZone imageZone;
        protected final InvoZone renderZone;
        protected float scale;

        public Image(ResourceLocation loc, float u0, float imageWidth, float v0, float imageHeight, float scale) {
            this.location = loc;
            this.imageZone = new InvoZone(u0, imageWidth, v0, imageHeight);
            this.renderZone = new InvoZone(0.0f, imageWidth, 0.0f, imageHeight);
            this.scale = scale;
        }

        public void resetScale() {
            this.renderZone.setWidth(this.imageZone.width());
            this.renderZone.setHeight(this.imageZone.height());
        }

        public InvoZone getRenderZone() {
            return this.renderZone;
        }

        public InvoZone getImageZone() {
            return this.imageZone;
        }

        public boolean isMouseOver(int mouseX, int mouseY) {
            return (float)mouseX >= this.renderZone.x() && (float)mouseX <= this.renderZone.x() + this.renderZone.width() && (float)mouseY >= this.renderZone.y() && (float)mouseY <= this.renderZone.y() + this.renderZone.height();
        }

        public void render(PoseStack stack) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.location);
            ClientUtil.blitImage(stack, this.renderZone, this.imageZone, this.scale);
        }
    }

    public static class SimpleButton
    extends Button {
        public boolean hidden = false;

        public SimpleButton(int x, int y, int width, int height, MutableComponent textComponent, Button.OnPress onPress) {
            super(x, y, width, height, (Component)textComponent, onPress, a -> textComponent);
            this.f_93624_ = true;
        }
    }
}

