/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams.zone;

import com.fullfud.teams.Teams;
import com.fullfud.teams.network.NetworkHandler;
import com.fullfud.teams.network.packet.SyncZonesAndScoresS2CPacket;
import com.fullfud.teams.server.TeamSelectionSavedData;
import com.fullfud.teams.zone.Zone;
import com.fullfud.teams.zone.ZonesSavedData;
import java.util.HashMap;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ZoneManager {
    private static final int TICKS_PER_SECOND = 20;
    private static final int CAP_RATE_PER_SEC = 5;
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = e.getServer();
        if (server == null) {
            return;
        }
        ZonesSavedData data = ZonesSavedData.get(server);
        if (data.zones.isEmpty()) {
            if (tickCounter % 100 == 0) {
                ZoneManager.broadcast(server, data);
            }
            ++tickCounter;
            return;
        }
        if (tickCounter % 20 == 0) {
            ServerLevel level = server.m_129880_(Level.f_46428_);
            if (level != null) {
                ZoneManager.tickCapture(level, data);
            }
            ZoneManager.broadcast(server, data);
        }
        if (tickCounter % 1200 == 0) {
            for (Zone z : data.zones.values()) {
                if (z.ownerTeam == null || !Teams.isKnownTeam(z.ownerTeam)) continue;
                data.addScore(z.ownerTeam, z.pointsPerMinute);
            }
            ZoneManager.broadcast(server, data);
        }
        ++tickCounter;
    }

    private static void tickCapture(ServerLevel level, ZonesSavedData data) {
        TeamSelectionSavedData teamData = TeamSelectionSavedData.get(level.m_7654_());
        for (Zone z : data.zones.values()) {
            AABB box = AABB.m_165882_((Vec3)z.center.m_252807_(), (double)((double)z.radius * 2.0 + 1.0), (double)((double)z.radius * 2.0 + 1.0), (double)((double)z.radius * 2.0 + 1.0));
            List players = level.m_45976_(ServerPlayer.class, box);
            HashMap<String, Integer> present = new HashMap<String, Integer>();
            for (ServerPlayer p : players) {
                double dz;
                double dx;
                String t = teamData.getTeam(p.m_20148_());
                if (!Teams.isKnownTeam(t) || !((dx = p.m_20185_() - ((double)z.center.m_123341_() + 0.5)) * dx + (dz = p.m_20189_() - ((double)z.center.m_123343_() + 0.5)) * dz <= (double)(z.radius * z.radius))) continue;
                present.merge(t, 1, Integer::sum);
            }
            if (present.isEmpty()) {
                if (z.capturingTeam == null) continue;
                z.progress = Math.max(0.0f, z.progress - 5.0f);
                if (z.progress != 0.0f) continue;
                z.capturingTeam = null;
                continue;
            }
            if (present.size() > 1) continue;
            String onlyTeam = (String)present.keySet().iterator().next();
            if (z.ownerTeam == null) {
                if (z.capturingTeam == null || !z.capturingTeam.equals(onlyTeam)) {
                    z.capturingTeam = onlyTeam;
                    z.progress = 0.0f;
                }
                z.progress = Math.min(100.0f, z.progress + 5.0f);
                if (!(z.progress >= 100.0f)) continue;
                z.ownerTeam = onlyTeam;
                z.capturingTeam = null;
                z.progress = 0.0f;
                data.m_77762_();
                continue;
            }
            if (z.ownerTeam.equals(onlyTeam)) {
                if (z.capturingTeam == null || z.capturingTeam.equals(z.ownerTeam)) continue;
                z.progress = Math.max(0.0f, z.progress - 5.0f);
                if (z.progress != 0.0f) continue;
                z.capturingTeam = null;
                continue;
            }
            if (z.capturingTeam == null || !z.capturingTeam.equals(onlyTeam)) {
                z.capturingTeam = onlyTeam;
                z.progress = 0.0f;
            }
            z.progress = Math.min(100.0f, z.progress + 5.0f);
            if (!(z.progress >= 100.0f)) continue;
            z.ownerTeam = onlyTeam;
            z.capturingTeam = null;
            z.progress = 0.0f;
            data.m_77762_();
        }
    }

    private static void broadcast(MinecraftServer server, ZonesSavedData data) {
        TeamSelectionSavedData teamData = TeamSelectionSavedData.get(server);
        for (ServerPlayer p : server.m_6846_().m_11314_()) {
            String st = teamData.getTeam(p.m_20148_());
            SyncZonesAndScoresS2CPacket pkt = SyncZonesAndScoresS2CPacket.from(data, st == null ? "" : st);
            NetworkHandler.sendToPlayer(p, pkt);
        }
    }
}

