/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams.zone;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class Zone {
    public final String id;
    public final BlockPos center;
    public final int radius;
    public final int pointsPerMinute;
    public String ownerTeam;
    public String capturingTeam;
    public float progress;

    public Zone(String id, BlockPos center, int radius, int pointsPerMinute) {
        this.id = id;
        this.center = center;
        this.radius = radius;
        this.pointsPerMinute = Math.max(1, pointsPerMinute);
    }

    public CompoundTag save() {
        CompoundTag t = new CompoundTag();
        t.m_128359_("id", this.id);
        t.m_128405_("x", this.center.m_123341_());
        t.m_128405_("y", this.center.m_123342_());
        t.m_128405_("z", this.center.m_123343_());
        t.m_128405_("radius", this.radius);
        t.m_128405_("ppm", this.pointsPerMinute);
        if (this.ownerTeam != null) {
            t.m_128359_("owner", this.ownerTeam);
        }
        if (this.capturingTeam != null) {
            t.m_128359_("cap", this.capturingTeam);
        }
        t.m_128350_("prog", this.progress);
        return t;
    }

    public static Zone load(CompoundTag t) {
        String id = t.m_128461_("id");
        BlockPos pos = new BlockPos(t.m_128451_("x"), t.m_128451_("y"), t.m_128451_("z"));
        int radius = t.m_128451_("radius");
        int ppm = Math.max(1, t.m_128451_("ppm"));
        Zone z = new Zone(id, pos, radius, ppm);
        if (t.m_128441_("owner")) {
            z.ownerTeam = t.m_128461_("owner");
        }
        if (t.m_128441_("cap")) {
            z.capturingTeam = t.m_128461_("cap");
        }
        z.progress = t.m_128457_("prog");
        return z;
    }
}

