/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams.server;

import com.fullfud.teams.ScoreboardSingleTeam;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fullfud_teams")
public class TeamCommands {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder teams = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"teams").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"join").executes(TeamCommands::executeJoinSelf)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).requires(src -> src.m_6761_(2))).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"target");
            ScoreboardSingleTeam.join(target);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0432 \u0435\u0434\u0438\u043d\u0443\u044e \u043a\u043e\u043c\u0430\u043d\u0434\u0443: " + target.m_36316_().getName())), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"target");
            TeamCommands.clearPlayerFromSingleTeam(target);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u0423\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0435\u0434\u0438\u043d\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: " + target.m_36316_().getName())), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all").executes(TeamCommands::executeClearAll)).then(Commands.m_82127_((String)"readd").executes(TeamCommands::executeClearAllAndReadd))));
        dispatcher.register(teams);
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"teamselect").executes(TeamCommands::executeJoinSelf));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ts").executes(TeamCommands::executeJoinSelf));
    }

    private static int executeJoinSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ScoreboardSingleTeam.join(player);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u0412\u044b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u044b \u0432 \u0435\u0434\u0438\u043d\u0443\u044e \u0432\u0430\u043d\u0438\u043b\u044c\u043d\u0443\u044e \u043a\u043e\u043c\u0430\u043d\u0434\u0443."), false);
        return 1;
    }

    private static int executeClearAll(CommandContext<CommandSourceStack> ctx) {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        int before = TeamCommands.getSingleTeamSize(server);
        ScoreboardSingleTeam.clearAll(server);
        int clearedCount = before;
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u0423\u0434\u0430\u043b\u0435\u043d\u044b \u0432\u0441\u0435 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0438 \u0438\u0437 \u0435\u0434\u0438\u043d\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b (\u043a\u043e\u043b-\u0432\u043e: " + clearedCount + ").")), true);
        return 1;
    }

    private static int executeClearAllAndReadd(CommandContext<CommandSourceStack> ctx) {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        int before = TeamCommands.getSingleTeamSize(server);
        ScoreboardSingleTeam.clearAll(server);
        ScoreboardSingleTeam.joinAllOnline(server);
        int clearedCount = before;
        int readded = server.m_6846_().m_11314_().size();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u041e\u0447\u0438\u0449\u0435\u043d\u043e \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u043e\u0432: " + clearedCount + ". \u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u043e\u043d\u043b\u0430\u0439\u043d-\u0438\u0433\u0440\u043e\u043a\u043e\u0432: " + readded + ".")), true);
        return 1;
    }

    private static int getSingleTeamSize(MinecraftServer server) {
        ServerScoreboard sb = server.m_129896_();
        PlayerTeam t = sb.m_83489_("allplayers");
        return t == null ? 0 : t.m_6809_().size();
    }

    private static void clearPlayerFromSingleTeam(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return;
        }
        ServerScoreboard sb = server.m_129896_();
        PlayerTeam t = sb.m_83489_("allplayers");
        if (t != null) {
            sb.m_6519_(player.m_6302_(), t);
        }
    }
}

