/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams.network.packet;

import com.fullfud.teams.client.ClientSelfData;
import com.fullfud.teams.client.ClientZoneData;
import com.fullfud.teams.zone.Zone;
import com.fullfud.teams.zone.ZonesSavedData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncZonesAndScoresS2CPacket {
    public final List<ZoneState> zones;
    public final Map<String, Integer> scores;
    public final String selfTeam;

    public SyncZonesAndScoresS2CPacket(List<ZoneState> zones, Map<String, Integer> scores, String selfTeam) {
        this.zones = zones;
        this.scores = scores;
        this.selfTeam = selfTeam == null ? "" : selfTeam;
    }

    public static SyncZonesAndScoresS2CPacket from(ZonesSavedData data, String selfTeam) {
        ArrayList<ZoneState> list = new ArrayList<ZoneState>();
        for (Zone z : data.zones.values()) {
            list.add(new ZoneState(z.id, z.center, z.radius, z.pointsPerMinute, z.ownerTeam == null ? "" : z.ownerTeam, z.capturingTeam == null ? "" : z.capturingTeam, z.progress));
        }
        return new SyncZonesAndScoresS2CPacket(list, new HashMap<String, Integer>(data.teamScores), selfTeam);
    }

    public static void encode(SyncZonesAndScoresS2CPacket msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.selfTeam);
        buf.m_130130_(msg.zones.size());
        for (ZoneState zoneState : msg.zones) {
            buf.m_130070_(zoneState.id);
            buf.m_130064_(zoneState.pos);
            buf.m_130130_(zoneState.radius);
            buf.m_130130_(zoneState.ppm);
            buf.m_130070_(zoneState.owner);
            buf.m_130070_(zoneState.capturing);
            buf.writeFloat(zoneState.progress);
        }
        buf.m_130130_(msg.scores.size());
        for (Map.Entry entry : msg.scores.entrySet()) {
            buf.m_130070_((String)entry.getKey());
            buf.m_130130_(((Integer)entry.getValue()).intValue());
        }
    }

    public static SyncZonesAndScoresS2CPacket decode(FriendlyByteBuf buf) {
        String selfTeam = buf.m_130277_();
        int n = buf.m_130242_();
        ArrayList<ZoneState> zones = new ArrayList<ZoneState>(n);
        for (int i = 0; i < n; ++i) {
            String id = buf.m_130277_();
            BlockPos pos = buf.m_130135_();
            int radius = buf.m_130242_();
            int ppm = buf.m_130242_();
            String owner = buf.m_130277_();
            String cap = buf.m_130277_();
            float prog = buf.readFloat();
            zones.add(new ZoneState(id, pos, radius, ppm, owner, cap, prog));
        }
        int m = buf.m_130242_();
        HashMap<String, Integer> scores = new HashMap<String, Integer>();
        for (int i = 0; i < m; ++i) {
            scores.put(buf.m_130277_(), buf.m_130242_());
        }
        return new SyncZonesAndScoresS2CPacket(zones, scores, selfTeam);
    }

    public static void handle(SyncZonesAndScoresS2CPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientSelfData.setTeam(msg.selfTeam);
            ClientZoneData.apply(msg);
        });
        ctx.get().setPacketHandled(true);
    }

    public static class ZoneState {
        public final String id;
        public final BlockPos pos;
        public final int radius;
        public final int ppm;
        public final String owner;
        public final String capturing;
        public final float progress;

        public ZoneState(String id, BlockPos pos, int radius, int ppm, String owner, String capturing, float progress) {
            this.id = id;
            this.pos = pos;
            this.radius = radius;
            this.ppm = ppm;
            this.owner = owner;
            this.capturing = capturing;
            this.progress = progress;
        }
    }
}

