/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams.network.packet;

import com.fullfud.teams.ScoreboardSingleTeam;
import com.fullfud.teams.Teams;
import com.fullfud.teams.server.TeamSelectionSavedData;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class SubmitTeamChoiceC2SPacket {
    private final String teamId;

    public SubmitTeamChoiceC2SPacket(String teamId) {
        this.teamId = teamId.toLowerCase(Locale.ROOT);
    }

    public static void encode(SubmitTeamChoiceC2SPacket pkt, FriendlyByteBuf buf) {
        buf.m_130072_(pkt.teamId, 32);
    }

    public static SubmitTeamChoiceC2SPacket decode(FriendlyByteBuf buf) {
        return new SubmitTeamChoiceC2SPacket(buf.m_130136_(32));
    }

    public static void handle(SubmitTeamChoiceC2SPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player == null) {
            ctx.get().setPacketHandled(true);
            return;
        }
        ctx.get().enqueueWork(() -> {
            String cmd;
            String choice = pkt.teamId;
            if (!Teams.isKnownTeam(choice)) {
                player.m_213846_((Component)Component.m_237113_((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u0432\u044b\u0431\u043e\u0440\u0430."));
                return;
            }
            MinecraftServer server = player.m_20194_();
            if (server == null) {
                return;
            }
            TeamSelectionSavedData data = TeamSelectionSavedData.get(server);
            String existing = data.getTeam(player.m_20148_());
            if (existing != null) {
                player.m_213846_((Component)Component.m_237110_((String)"fullfud_teams.already_selected", (Object[])new Object[]{existing}));
                return;
            }
            data.setTeam(player.m_20148_(), choice);
            data.m_77762_();
            switch (choice) {
                case "usa": {
                    String string = "/joinusa";
                    break;
                }
                case "tagil": {
                    String string = "/jointagil";
                    break;
                }
                case "isis": {
                    String string = "/joinisis";
                    break;
                }
                default: {
                    String string = cmd = "";
                }
            }
            if (!cmd.isEmpty()) {
                server.m_129892_().m_230957_(player.m_20203_(), cmd);
            }
            ScoreboardSingleTeam.ensureExists(server);
            ScoreboardSingleTeam.join(player);
            ScoreboardSingleTeam.purgeKnownFactionTeams(server);
            player.m_213846_((Component)Component.m_237110_((String)"fullfud_teams.selected", (Object[])new Object[]{choice}));
        });
        ctx.get().setPacketHandled(true);
    }
}

