/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams.client.screen;

import com.fullfud.teams.network.NetworkHandler;
import com.fullfud.teams.network.packet.SubmitTeamChoiceC2SPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TeamSelectScreen
extends Screen {
    private static final ResourceLocation USA = new ResourceLocation("fullfud_teams", "textures/gui/usa.png");
    private static final ResourceLocation TAGIL = new ResourceLocation("fullfud_teams", "textures/gui/tagil.png");
    private static final ResourceLocation ISIS = new ResourceLocation("fullfud_teams", "textures/gui/isis.png");
    private int panelX;
    private int panelY;
    private int panelW;
    private int panelH;
    private int gap;
    private int iconSize;
    private final List<TeamCard> cards = new ArrayList<TeamCard>();

    public TeamSelectScreen() {
        super((Component)Component.m_237115_((String)"fullfud_teams.gui.title"));
    }

    protected void m_7856_() {
        this.m_169413_();
        this.cards.clear();
        int margin = Mth.m_14045_((int)((int)((float)Math.min(this.f_96543_, this.f_96544_) * 0.05f)), (int)12, (int)28);
        this.panelW = Mth.m_14045_((int)((int)((float)this.f_96543_ * 0.82f)), (int)360, (int)(this.f_96543_ - margin * 2));
        this.panelH = Mth.m_14045_((int)((int)((float)this.f_96544_ * 0.6f)), (int)200, (int)(this.f_96544_ - margin * 2));
        this.panelX = (this.f_96543_ - this.panelW) / 2;
        this.panelY = (this.f_96544_ - this.panelH) / 2;
        int headerH = 36;
        int footerH = 12;
        this.gap = Mth.m_14045_((int)(this.panelW / 40), (int)10, (int)28);
        this.iconSize = Mth.m_14045_((int)((this.panelW - this.gap * 4) / 3), (int)64, (int)176);
        int cardTotalH = this.iconSize + 26;
        if (cardTotalH > this.panelH - headerH - footerH) {
            this.iconSize = Mth.m_14045_((int)(this.panelH - headerH - footerH - 26), (int)56, (int)160);
        }
        int rowY = this.panelY + headerH + (this.panelH - headerH - footerH - (this.iconSize + 26)) / 2;
        int startX = this.panelX + (this.panelW - (this.iconSize * 3 + this.gap * 2)) / 2;
        TeamCard usa = new TeamCard(startX, rowY, this.iconSize, (Component)Component.m_237115_((String)"fullfud_teams.team.usa"), "usa", USA);
        TeamCard tagil = new TeamCard(startX + this.iconSize + this.gap, rowY, this.iconSize, (Component)Component.m_237115_((String)"fullfud_teams.team.tagil"), "tagil", TAGIL);
        TeamCard isis = new TeamCard(startX + (this.iconSize + this.gap) * 2, rowY, this.iconSize, (Component)Component.m_237115_((String)"fullfud_teams.team.isis"), "isis", ISIS);
        usa.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"/joinusa")));
        tagil.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"/jointagil")));
        isis.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"/joinisis")));
        this.cards.add(usa);
        this.cards.add(tagil);
        this.cards.add(isis);
        for (TeamCard c : this.cards) {
            this.m_142416_((GuiEventListener)c);
        }
        Button cancel = Button.m_253074_((Component)CommonComponents.f_130656_, b -> this.m_7379_()).m_252987_(this.panelX + this.panelW - 88 - this.gap, this.panelY + this.panelH - 24 - this.gap, 88, 20).m_253136_();
        this.m_142416_((GuiEventListener)cancel);
    }

    private void choose(String id) {
        NetworkHandler.CHANNEL.sendToServer((Object)new SubmitTeamChoiceC2SPacket(id));
        this.m_7379_();
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(gfx);
        gfx.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1342177280, Integer.MIN_VALUE);
        gfx.m_280509_(this.panelX + 4, this.panelY + 4, this.panelX + this.panelW + 4, this.panelY + this.panelH + 4, 0x66000000);
        gfx.m_280509_(this.panelX, this.panelY, this.panelX + this.panelW, this.panelY + this.panelH, -1441787888);
        this.drawBorder(gfx, this.panelX, this.panelY, this.panelW, this.panelH, 0x55FFFFFF);
        Component title = this.m_96636_();
        int titleY = this.panelY + 10;
        gfx.m_280653_(this.f_96547_, title, this.panelX + this.panelW / 2, titleY, 0xFFFFFF);
        MutableComponent sub = Component.m_237115_((String)"fullfud_teams.gui.subtitle");
        gfx.m_280653_(this.f_96547_, (Component)sub, this.panelX + this.panelW / 2, titleY + 12, -3092272);
        super.m_88315_(gfx, mouseX, mouseY, partialTick);
    }

    private void drawBorder(GuiGraphics gfx, int x, int y, int w, int h, int color) {
        gfx.m_280509_(x, y, x + w, y + 1, color);
        gfx.m_280509_(x, y + h - 1, x + w, y + h, color);
        gfx.m_280509_(x, y, x + 1, y + h, color);
        gfx.m_280509_(x + w - 1, y, x + w, y + h, color);
    }

    public boolean m_7043_() {
        return false;
    }

    private class TeamCard
    extends AbstractWidget {
        private final String teamId;
        private final ResourceLocation texture;
        private final int iconSize;
        private final int pad = 6;

        public TeamCard(int x, int y, int iconSize, Component label, String teamId, ResourceLocation texture) {
            super(x, y, iconSize, iconSize + 24, label);
            this.pad = 6;
            this.iconSize = iconSize;
            this.teamId = teamId;
            this.texture = texture;
        }

        protected void m_87963_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
            boolean hover = this.f_93622_;
            int bg = hover ? -1440866786 : -1441458923;
            int shadow = 0x44000000;
            gfx.m_280509_(this.m_252754_() + 3, this.m_252907_() + 3, this.m_252754_() + this.f_93618_ + 3, this.m_252907_() + this.f_93619_ + 3, shadow);
            gfx.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_ - 22, bg);
            if (hover) {
                TeamSelectScreen.this.drawBorder(gfx, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_ - 22, 0x66FFFFFF);
            } else {
                TeamSelectScreen.this.drawBorder(gfx, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_ - 22, 0x33222222);
            }
            int inner = this.iconSize - 12;
            int ix = this.m_252754_() + 6;
            int iy = this.m_252907_() + 6;
            gfx.m_280163_(this.texture, ix, iy, 0.0f, 0.0f, inner, inner, inner, inner);
            int textY = this.m_252907_() + this.f_93619_ - 18;
            Component label = this.m_6035_();
            gfx.m_280653_(TeamSelectScreen.this.f_96547_, label, this.m_252754_() + this.f_93618_ / 2, textY, hover ? -1 : -1118482);
        }

        public void m_5716_(double mouseX, double mouseY) {
            TeamSelectScreen.this.choose(this.teamId);
        }

        protected void m_168797_(NarrationElementOutput narration) {
            this.m_168802_(narration);
        }
    }
}

