/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams.client;

import com.fullfud.teams.Teams;
import com.fullfud.teams.client.ClientSelfData;
import com.fullfud.teams.client.ClientZoneData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public enum ZoneHudOverlay implements IGuiOverlay
{
    INSTANCE;

    private static final double HUD_RANGE = 100.0;

    public void render(ForgeGui gui, GuiGraphics gfx, float partialTick, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91074_ == null) {
            return;
        }
        boolean near = this.isNearAnyZone(mc.f_91074_.m_20185_(), mc.f_91074_.m_20189_());
        if (!near) {
            return;
        }
        int panelW = 220;
        int panelH = 28;
        int x = (width - panelW) / 2;
        int y = height - 64;
        int bg = -2013265920;
        gfx.m_280509_(x, y, x + panelW, y + panelH, bg);
        int colW = panelW / 3;
        this.drawTeamBox(gfx, x + 0 * colW, y, colW, panelH, "TAGIL", -13705091, ClientZoneData.SCORES.getOrDefault("tagil", 0));
        this.drawTeamBox(gfx, x + 1 * colW, y, colW, panelH, "USA", -12737025, ClientZoneData.SCORES.getOrDefault("usa", 0));
        this.drawTeamBox(gfx, x + 2 * colW, y, colW, panelH, "ISIS", -43691, ClientZoneData.SCORES.getOrDefault("isis", 0));
        ClientZoneData.ClientZone cap = this.findMyCapture(mc.f_91074_.m_20185_(), mc.f_91074_.m_20189_());
        if (cap != null) {
            String text = "CAPTURING " + cap.id + " " + Math.round(cap.progress) + "%";
            int tw = mc.f_91062_.m_92895_(text);
            int pad = 4;
            int bx = x + (panelW - (tw + pad * 2)) / 2;
            int by = y - 14;
            gfx.m_280509_(bx, by, bx + tw + pad * 2, by + 12, -1342177280);
            gfx.m_280509_(bx, by, bx + tw + pad * 2, by + 1, 0x44FFFFFF);
            gfx.m_280509_(bx, by + 11, bx + tw + pad * 2, by + 12, 0x44FFFFFF);
            gfx.m_280509_(bx, by, bx + 1, by + 12, 0x44FFFFFF);
            gfx.m_280509_(bx + tw + pad * 2 - 1, by, bx + tw + pad * 2, by + 12, 0x44FFFFFF);
            gfx.m_280056_(mc.f_91062_, text, bx + pad, by + 2, Teams.colorOf(ClientSelfData.getTeam()), false);
        }
    }

    private boolean isNearAnyZone(double px, double pz) {
        double range2 = 10000.0;
        for (ClientZoneData.ClientZone z : ClientZoneData.ZONES.values()) {
            double dz;
            double dx = (double)z.pos.m_123341_() + 0.5 - px;
            if (!(dx * dx + (dz = (double)z.pos.m_123343_() + 0.5 - pz) * dz <= range2)) continue;
            return true;
        }
        return false;
    }

    private ClientZoneData.ClientZone findMyCapture(double px, double pz) {
        String my = ClientSelfData.getTeam();
        if (my.isEmpty()) {
            return null;
        }
        ClientZoneData.ClientZone best = null;
        double bestD2 = Double.MAX_VALUE;
        for (ClientZoneData.ClientZone z : ClientZoneData.ZONES.values()) {
            double dz;
            double dx;
            double d2;
            if (!my.equals(z.capturing) || !((d2 = (dx = (double)z.pos.m_123341_() + 0.5 - px) * dx + (dz = (double)z.pos.m_123343_() + 0.5 - pz) * dz) <= (double)z.radius * (double)z.radius) || !(d2 < bestD2)) continue;
            bestD2 = d2;
            best = z;
        }
        return best;
    }

    private void drawTeamBox(GuiGraphics gfx, int x, int y, int w, int h, String name, int color, int score) {
        int border = 0x44FFFFFF;
        gfx.m_280509_(x, y, x + w, y + 1, border);
        gfx.m_280509_(x, y + h - 1, x + w, y + h, border);
        gfx.m_280509_(x, y, x + 1, y + h, border);
        gfx.m_280509_(x + w - 1, y, x + w, y + h, border);
        int mid = y + 6;
        gfx.m_280137_(Minecraft.m_91087_().f_91062_, name, x + w / 2, mid - 6, color);
        gfx.m_280137_(Minecraft.m_91087_().f_91062_, String.valueOf(score), x + w / 2, mid + 6, -1);
    }
}

