/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams;

import java.util.List;
import java.util.Map;

public final class Teams {
    public static final String TAGIL = "tagil";
    public static final String USA = "usa";
    public static final String ISIS = "isis";
    public static final int COLOR_TAGIL = -13705091;
    public static final int COLOR_USA = -12737025;
    public static final int COLOR_ISIS = -43691;
    public static final int COLOR_TEXT = -1;
    public static final int COLOR_NEUTRAL = -4473925;
    private static final Map<String, Integer> COLORS = Map.of("tagil", -13705091, "usa", -12737025, "isis", -43691);

    public static int colorOf(String teamId) {
        return COLORS.getOrDefault(teamId, -1);
    }

    public static String displayNameOf(String teamId) {
        if (teamId == null || teamId.isEmpty()) {
            return "\u2014";
        }
        switch (teamId) {
            case "tagil": {
                return "TAGIL";
            }
            case "usa": {
                return "USA";
            }
            case "isis": {
                return "ISIS";
            }
        }
        return teamId;
    }

    public static boolean isKnownTeam(String s) {
        return TAGIL.equals(s) || USA.equals(s) || ISIS.equals(s);
    }

    public static List<String> all() {
        return List.of(TAGIL, USA, ISIS);
    }

    private Teams() {
    }
}

