/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;

public final class ScoreboardSingleTeam {
    public static final String TEAM_ID = "allplayers";
    public static final String TEAM_DISPLAY = "ALL PLAYERS";
    public static final ChatFormatting TEAM_COLOR = ChatFormatting.GRAY;

    public static void ensureExists(MinecraftServer server) {
        ServerScoreboard sb = server.m_129896_();
        PlayerTeam team = sb.m_83489_(TEAM_ID);
        if (team == null) {
            team = sb.m_83492_(TEAM_ID);
        }
        team.m_83353_((Component)Component.m_237113_((String)TEAM_DISPLAY));
        team.m_83351_(TEAM_COLOR);
    }

    public static void join(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return;
        }
        ScoreboardSingleTeam.ensureExists(server);
        ServerScoreboard sb = server.m_129896_();
        PlayerTeam team = sb.m_83489_(TEAM_ID);
        if (team == null) {
            return;
        }
        String name = player.m_6302_();
        PlayerTeam old = sb.m_83500_(name);
        if (old != null && old != team) {
            sb.m_6519_(name, old);
        }
        sb.m_6546_(name, team);
    }

    public static void clearAll(MinecraftServer server) {
        ServerScoreboard sb = server.m_129896_();
        PlayerTeam team = sb.m_83489_(TEAM_ID);
        if (team == null) {
            return;
        }
        for (String name : new ArrayList(team.m_6809_())) {
            sb.m_6519_(name, team);
        }
    }

    public static void joinAllOnline(MinecraftServer server) {
        ScoreboardSingleTeam.ensureExists(server);
        for (ServerPlayer p : server.m_6846_().m_11314_()) {
            ScoreboardSingleTeam.join(p);
        }
    }

    public static void purgeKnownFactionTeams(MinecraftServer server) {
        String[] factionIds;
        ServerScoreboard sb = server.m_129896_();
        for (String id : factionIds = new String[]{"usa", "tagil", "isis"}) {
            PlayerTeam t = sb.m_83489_(id);
            if (t == null) continue;
            for (String name : new ArrayList(t.m_6809_())) {
                sb.m_6519_(name, t);
            }
            sb.m_83475_(t);
        }
    }

    private ScoreboardSingleTeam() {
    }
}

