/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams;

import com.fullfud.teams.ScoreboardSingleTeam;
import com.fullfud.teams.network.NetworkHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="fullfud_teams")
public class FullfudTeamsMod {
    public static final String MODID = "fullfud_teams";

    public FullfudTeamsMod() {
        NetworkHandler.register();
    }

    @Mod.EventBusSubscriber(modid="fullfud_teams", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void onServerStarted(ServerStartedEvent e) {
            ScoreboardSingleTeam.ensureExists(e.getServer());
            ScoreboardSingleTeam.purgeKnownFactionTeams(e.getServer());
            ScoreboardSingleTeam.joinAllOnline(e.getServer());
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
            Player player = e.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)player;
                ScoreboardSingleTeam.join(p);
            }
        }
    }
}

