/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.loadingrequirements;

import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirementRegistry;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildRequirementScreen
extends Screen {
    protected Screen parentScreen;
    protected LoadingRequirementContainer parent;
    protected final LoadingRequirementInstance instance;
    protected boolean isEdit;
    protected Consumer<LoadingRequirementInstance> callback;
    protected ScrollArea requirementsListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ScrollArea requirementDescriptionScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedEditBox searchBar;

    public BuildRequirementScreen(@Nullable Screen parentScreen, @NotNull LoadingRequirementContainer parent, @Nullable LoadingRequirementInstance instanceToEdit, @NotNull Consumer<LoadingRequirementInstance> callback) {
        super((Component)(instanceToEdit != null ? Component.m_237115_((String)"fancymenu.editor.loading_requirement.screens.edit_requirement") : Component.m_237115_((String)"fancymenu.editor.loading_requirement.screens.add_requirement")));
        this.parentScreen = parentScreen;
        this.parent = parent;
        this.instance = instanceToEdit != null ? instanceToEdit : new LoadingRequirementInstance(null, null, LoadingRequirementInstance.RequirementMode.IF, parent);
        this.isEdit = instanceToEdit != null;
        this.callback = callback;
    }

    protected void m_7856_() {
        String oldSearchValue = this.searchBar != null ? this.searchBar.m_94155_() : "";
        this.searchBar = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, 21, 66, this.f_96543_ / 2 - 40 - 2, 18, (Component)Component.m_237119_()){

            @Override
            public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                super.m_87963_(graphics, mouseX, mouseY, partial);
                if (this.m_94155_().isBlank() && !this.m_93696_()) {
                    MutableComponent mutableComponent = Component.m_237115_((String)"fancymenu.requirements.build_requirement.screen.search_requirement");
                    int n = this.m_252754_() + 4;
                    int n2 = this.m_252907_() + this.m_93694_() / 2;
                    Objects.requireNonNull(this.font);
                    graphics.m_280614_(this.font, (Component)mutableComponent, n, n2 - 9 / 2, UIBase.getUIColorTheme().edit_box_text_color_uneditable.getColorInt(), false);
                }
            }
        };
        this.searchBar.m_94144_(oldSearchValue);
        this.searchBar.m_94151_(s -> this.updateRequirementsList());
        this.m_142416_((GuiEventListener)this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.requirementsListScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.requirementsListScrollArea.setHeight(this.f_96544_ - 85 - 25, true);
        this.requirementsListScrollArea.setX(20, true);
        this.requirementsListScrollArea.setY(90, true);
        this.requirementDescriptionScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.requirementDescriptionScrollArea.setHeight(Math.max(40, this.f_96544_ / 2 - 50 - 25), true);
        this.requirementDescriptionScrollArea.setX(this.f_96543_ - 20 - this.requirementDescriptionScrollArea.getWidthWithBorder(), true);
        this.requirementDescriptionScrollArea.setY(65, true);
        int doneButtonX = this.f_96543_ - 20 - 150;
        int doneButtonY = this.f_96544_ - 20 - 20;
        int cancelButtonX = doneButtonX;
        int cancelButtonY = doneButtonY - 5 - 20;
        int editValueButtonX = doneButtonX;
        int editValueButtonY = (this.isEdit ? doneButtonY : cancelButtonY) - 15 - 20;
        int requirementModeButtonX = doneButtonX;
        int requirementModeButtonY = editValueButtonY - 5 - 20;
        ExtendedButton editValueButton = new ExtendedButton(editValueButtonX, editValueButtonY, 150, 20, (Component)Component.m_237115_((String)"fancymenu.editor.loading_requirement.screens.build_screen.edit_value"), button -> {
            if (this.instance.requirement != null) {
                this.instance.requirement.editValue(this, this.instance);
            }
        }).setTooltipSupplier(consumes -> {
            if (this.instance.requirement != null && !this.instance.requirement.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.loading_requirement.screens.build_screen.edit_value.desc.no_value", new String[0]));
            }
            return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.loading_requirement.screens.build_screen.edit_value.desc.normal", new String[0]));
        }).setIsActiveSupplier(consumes -> this.instance.requirement != null && this.instance.requirement.hasValue());
        this.m_142416_((GuiEventListener)editValueButton);
        UIBase.applyDefaultWidgetSkinTo(editValueButton);
        ExtendedButton doneButton = new ExtendedButton(doneButtonX, doneButtonY, 150, 20, (Component)Component.m_237115_((String)"fancymenu.guicomponents.done"), button -> {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
            this.callback.accept(this.instance);
        }).setTooltipSupplier(consumes -> {
            if (this.instance.requirement == null) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.loading_requirement.screens.build_screen.finish.desc.no_requirement_selected", new String[0]));
            }
            if (this.instance.value == null && this.instance.requirement.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.loading_requirement.screens.build_screen.finish.desc.no_value_set", new String[0]));
            }
            return null;
        }).setIsActiveSupplier(consumes -> {
            if (this.instance.requirement == null) {
                return false;
            }
            if (this.instance.value == null && this.instance.requirement.hasValue()) {
                return false;
            }
            return true;
        });
        this.m_142416_((GuiEventListener)doneButton);
        UIBase.applyDefaultWidgetSkinTo(doneButton);
        ExtendedButton cancelButton = new ExtendedButton(cancelButtonX, cancelButtonY, 150, 20, (Component)Component.m_237115_((String)"fancymenu.guicomponents.cancel"), button -> {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
            if (this.isEdit) {
                this.callback.accept(this.instance);
            } else {
                this.callback.accept(null);
            }
        }).setIsActiveSupplier(consumes -> !this.isEdit);
        cancelButton.f_93624_ = !this.isEdit;
        this.m_142416_((GuiEventListener)cancelButton);
        UIBase.applyDefaultWidgetSkinTo(cancelButton);
        ExtendedButton requirementModeButton = new ExtendedButton(requirementModeButtonX, requirementModeButtonY, 150, 20, (Component)Component.m_237119_(), button -> {
            this.instance.mode = this.instance.mode == LoadingRequirementInstance.RequirementMode.IF ? LoadingRequirementInstance.RequirementMode.IF_NOT : LoadingRequirementInstance.RequirementMode.IF;
        }).setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.loading_requirement.screens.build_screen.requirement_mode.desc", new String[0]))).setLabelSupplier(consumes -> {
            if (this.instance.mode == LoadingRequirementInstance.RequirementMode.IF) {
                return Component.m_237115_((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_mode.normal");
            }
            return Component.m_237115_((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_mode.opposite");
        });
        this.m_142416_((GuiEventListener)requirementModeButton);
        UIBase.applyDefaultWidgetSkinTo(requirementModeButton);
        this.updateRequirementsList();
        this.setDescription(this.instance.requirement);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parentScreen);
        if (this.isEdit) {
            this.callback.accept(this.instance);
        } else {
            this.callback.accept(null);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        graphics.m_280614_(this.f_96547_, (Component)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"fancymenu.editor.loading_requirement.screens.build_screen.available_requirements"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.requirementsListScrollArea.render(graphics, mouseX, mouseY, partial);
        MutableComponent descLabel = Component.m_237115_((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_description");
        int descLabelWidth = this.f_96547_.m_92852_((FormattedText)descLabel);
        graphics.m_280614_(this.f_96547_, (Component)descLabel, this.f_96543_ - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.requirementDescriptionScrollArea.render(graphics, mouseX, mouseY, partial);
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    protected void setDescription(@Nullable LoadingRequirement requirement) {
        this.requirementDescriptionScrollArea.clearEntries();
        if (requirement != null && requirement.getDescription() != null) {
            for (String s : requirement.getDescription()) {
                TextScrollAreaEntry e = new TextScrollAreaEntry(this.requirementDescriptionScrollArea, (Component)Component.m_237113_((String)s).m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), entry -> {});
                e.setSelectable(false);
                e.setBackgroundColorHover(e.getBackgroundColorIdle());
                e.setPlayClickSound(false);
                this.requirementDescriptionScrollArea.addEntry(e);
            }
        }
    }

    protected boolean requirementFitsSearchValue(@NotNull LoadingRequirement requirement, @Nullable String s) {
        if (s == null || s.isBlank()) {
            return true;
        }
        s = s.toLowerCase();
        if (requirement.getDisplayName().toLowerCase().contains(s)) {
            return true;
        }
        return this.requirementDescriptionContains(requirement, s);
    }

    protected boolean requirementDescriptionContains(@NotNull LoadingRequirement requirement, @NotNull String s) {
        List desc = Objects.requireNonNullElse(requirement.getDescription(), new ArrayList());
        for (String line : desc) {
            if (!line.toLowerCase().contains(s)) continue;
            return true;
        }
        return false;
    }

    protected void setContentOfRequirementsList(@Nullable String category) {
        block7: {
            LinkedHashMap<String, List<LoadingRequirement>> categories;
            block6: {
                TextListScrollAreaEntry e;
                MutableComponent label;
                String searchValue;
                String string = searchValue = this.searchBar != null ? this.searchBar.m_94155_() : "";
                if (searchValue.isBlank()) {
                    searchValue = null;
                }
                this.requirementsListScrollArea.clearEntries();
                if (searchValue != null) {
                    for (LoadingRequirement r : LoadingRequirementRegistry.getRequirements()) {
                        if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance()) || !this.requirementFitsSearchValue(r, searchValue)) continue;
                        MutableComponent label2 = Component.m_237113_((String)r.getDisplayName()).m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                        RequirementScrollEntry e2 = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)label2, UIBase.getUIColorTheme().listing_dot_color_1.getColor(), entry -> {
                            this.instance.requirement = r;
                            this.setDescription(this.instance.requirement);
                        });
                        e2.requirement = r;
                        this.requirementsListScrollArea.addEntry(e2);
                    }
                    return;
                }
                categories = LoadingRequirementRegistry.getRequirementsOrderedByCategories();
                if (category != null) break block6;
                for (Map.Entry<String, List<LoadingRequirement>> m : categories.entrySet()) {
                    label = Component.m_237113_((String)m.getKey()).m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                    e = new TextListScrollAreaEntry(this.requirementsListScrollArea, (Component)label, UIBase.getUIColorTheme().listing_dot_color_2.getColor(), entry -> {
                        this.setContentOfRequirementsList((String)m.getKey());
                        this.instance.requirement = null;
                        this.setDescription(null);
                    });
                    e.setSelectable(false);
                    this.requirementsListScrollArea.addEntry(e);
                }
                for (LoadingRequirement r : LoadingRequirementRegistry.getRequirementsWithoutCategory()) {
                    if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                    label = Component.m_237113_((String)r.getDisplayName()).m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                    e = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)label, UIBase.getUIColorTheme().listing_dot_color_1.getColor(), entry -> {
                        this.instance.requirement = r;
                        this.setDescription(this.instance.requirement);
                    });
                    ((RequirementScrollEntry)e).requirement = r;
                    this.requirementsListScrollArea.addEntry(e);
                }
                break block7;
            }
            MutableComponent backLabel = Component.m_237115_((String)"fancymenu.editor.loading_requirement.screens.lists.back").m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
            TextListScrollAreaEntry backEntry = new TextListScrollAreaEntry(this.requirementsListScrollArea, (Component)backLabel, UIBase.getUIColorTheme().listing_dot_color_2.getColor(), entry -> {
                this.setContentOfRequirementsList(null);
                this.instance.requirement = null;
                this.setDescription(null);
            });
            backEntry.setSelectable(false);
            this.requirementsListScrollArea.addEntry(backEntry);
            List<LoadingRequirement> l = categories.get(category);
            if (l == null) break block7;
            for (LoadingRequirement r : l) {
                if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                MutableComponent label = Component.m_237113_((String)r.getDisplayName()).m_130948_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)label, UIBase.getUIColorTheme().listing_dot_color_1.getColor(), entry -> {
                    this.instance.requirement = r;
                    this.setDescription(this.instance.requirement);
                });
                e.requirement = r;
                this.requirementsListScrollArea.addEntry(e);
            }
        }
    }

    protected void updateRequirementsList() {
        this.setContentOfRequirementsList(null);
        if (this.instance.requirement != null) {
            this.setContentOfRequirementsList(this.instance.requirement.getCategory());
            for (ScrollAreaEntry e : this.requirementsListScrollArea.getEntries()) {
                if (!(e instanceof RequirementScrollEntry) || ((RequirementScrollEntry)e).requirement != this.instance.requirement) continue;
                e.setSelected(true);
                break;
            }
        }
    }

    public static class RequirementScrollEntry
    extends TextListScrollAreaEntry {
        public LoadingRequirement requirement;

        public RequirementScrollEntry(ScrollArea parent, @NotNull Component text, @NotNull Color listDotColor, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, text, listDotColor, onClick);
        }
    }
}

