/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.blocks;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.action.Executable;
import de.keksuccino.fancymenu.customization.action.ValuePlaceholderHolder;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExecutableBlock
implements Executable,
ValuePlaceholderHolder {
    protected final List<Executable> executables = new ArrayList<Executable>();
    @NotNull
    protected final Map<String, Supplier<String>> valuePlaceholders = new HashMap<String, Supplier<String>>();
    @NotNull
    public String identifier = ScreenCustomization.generateUniqueIdentifier();

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    public abstract String getBlockType();

    @Override
    public void execute() {
        for (Executable e : this.executables) {
            e.execute();
        }
    }

    @Override
    public void addValuePlaceholder(@NotNull String placeholder, @NotNull Supplier<String> replaceWithSupplier) {
        if (!CharacterFilter.buildResourceNameFilter().isAllowedText(placeholder)) {
            throw new RuntimeException("Illegal characters used in placeholder name! Use only [a-z], [0-9], [_], [-]!");
        }
        this.valuePlaceholders.put(placeholder, replaceWithSupplier);
        for (Executable e : this.executables) {
            if (!(e instanceof ValuePlaceholderHolder)) continue;
            ValuePlaceholderHolder h = (ValuePlaceholderHolder)((Object)e);
            h.addValuePlaceholder(placeholder, replaceWithSupplier);
        }
        if (this.getAppendedBlock() != null) {
            this.getAppendedBlock().addValuePlaceholder(placeholder, replaceWithSupplier);
        }
    }

    @Override
    @NotNull
    public Map<String, Supplier<String>> getValuePlaceholders() {
        return this.valuePlaceholders;
    }

    public List<Executable> getExecutables() {
        return this.executables;
    }

    public AbstractExecutableBlock addExecutable(Executable executable) {
        this.executables.add(executable);
        if (executable instanceof ValuePlaceholderHolder) {
            ValuePlaceholderHolder h = (ValuePlaceholderHolder)((Object)executable);
            this.valuePlaceholders.forEach(h::addValuePlaceholder);
        }
        return this;
    }

    public AbstractExecutableBlock removeExecutable(Executable executable) {
        this.executables.remove(executable);
        return this;
    }

    public AbstractExecutableBlock clearExecutables() {
        this.executables.clear();
        return this;
    }

    @Nullable
    public AbstractExecutableBlock getAppendedBlock() {
        return null;
    }

    public void setAppendedBlock(@Nullable AbstractExecutableBlock appended) {
        if (appended != null) {
            this.valuePlaceholders.forEach(appended::addValuePlaceholder);
        }
    }

    @Override
    @NotNull
    public PropertyContainer serialize() {
        PropertyContainer container = new PropertyContainer("executable_block");
        String key = "[executable_block:" + this.identifier + "][type:" + this.getBlockType() + "]";
        Object value = "[executables:";
        for (Executable e : this.executables) {
            value = (String)value + e.getIdentifier() + ";";
            e.serializeToExistingPropertyContainer(container);
        }
        value = (String)value + "]";
        if (this.getAppendedBlock() != null) {
            value = (String)value + "[appended:" + this.getAppendedBlock().getIdentifier() + "]";
        }
        container.putProperty(key, (String)value);
        if (this.getAppendedBlock() != null) {
            this.getAppendedBlock().serializeToExistingPropertyContainer(container);
        }
        return container;
    }
}

