/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams.zone;

import com.fullfud.teams.zone.Zone;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class ZonesSavedData
extends SavedData {
    private static final String ID = "fullfud_zones";
    public final Map<String, Zone> zones = new LinkedHashMap<String, Zone>();
    public final Map<String, Integer> teamScores = new HashMap<String, Integer>();

    public ZonesSavedData() {
        this.teamScores.putIfAbsent("tagil", 0);
        this.teamScores.putIfAbsent("usa", 0);
        this.teamScores.putIfAbsent("isis", 0);
    }

    public static ZonesSavedData get(MinecraftServer server) {
        ServerLevel level = server.m_129880_(Level.f_46428_);
        if (level == null) {
            throw new IllegalStateException("Overworld not found");
        }
        return (ZonesSavedData)level.m_8895_().m_164861_(ZonesSavedData::load, ZonesSavedData::new, ID);
    }

    public static ZonesSavedData load(CompoundTag tag) {
        ZonesSavedData data = new ZonesSavedData();
        ListTag list = tag.m_128437_("zones", 10);
        for (int i = 0; i < list.size(); ++i) {
            Zone z = Zone.load(list.m_128728_(i));
            data.zones.put(z.id, z);
        }
        CompoundTag scores = tag.m_128469_("scores");
        for (String k : scores.m_128431_()) {
            data.teamScores.put(k, scores.m_128451_(k));
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (Zone z : this.zones.values()) {
            list.add((Object)z.save());
        }
        tag.m_128365_("zones", (Tag)list);
        CompoundTag scores = new CompoundTag();
        for (Map.Entry<String, Integer> e : this.teamScores.entrySet()) {
            scores.m_128405_(e.getKey(), e.getValue().intValue());
        }
        tag.m_128365_("scores", (Tag)scores);
        return tag;
    }

    public void addScore(String team, int points) {
        this.teamScores.put(team, this.teamScores.getOrDefault(team, 0) + points);
        this.m_77762_();
    }
}

