/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams.server;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class TeamSelectionSavedData
extends SavedData {
    private static final String DATA_NAME = "fullfud_teams";
    private final Map<UUID, String> teams = new HashMap<UUID, String>();

    public static TeamSelectionSavedData get(MinecraftServer server) {
        ServerLevel level = server.m_129880_(Level.f_46428_);
        if (level == null) {
            throw new IllegalStateException("Overworld not found");
        }
        return (TeamSelectionSavedData)level.m_8895_().m_164861_(TeamSelectionSavedData::load, TeamSelectionSavedData::new, DATA_NAME);
    }

    public static TeamSelectionSavedData load(CompoundTag tag) {
        TeamSelectionSavedData data = new TeamSelectionSavedData();
        CompoundTag players = tag.m_128469_("players");
        for (String key : players.m_128431_()) {
            try {
                UUID uuid = UUID.fromString(key);
                String team = players.m_128461_(key);
                data.teams.put(uuid, team);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag players = new CompoundTag();
        for (Map.Entry<UUID, String> e : this.teams.entrySet()) {
            players.m_128359_(e.getKey().toString(), e.getValue());
        }
        tag.m_128365_("players", (Tag)players);
        return tag;
    }

    public String getTeam(UUID uuid) {
        return this.teams.get(uuid);
    }

    public void setTeam(UUID uuid, String team) {
        this.teams.put(uuid, team);
        this.m_77762_();
    }

    public boolean clearTeam(UUID uuid) {
        boolean removed;
        boolean bl = removed = this.teams.remove(uuid) != null;
        if (removed) {
            this.m_77762_();
        }
        return removed;
    }
}

