/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams.commands;

import com.fullfud.teams.zone.Zone;
import com.fullfud.teams.zone.ZonesSavedData;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ZoneCommand {
    @SubscribeEvent
    public static void onRegister(RegisterCommandsEvent e) {
        e.getDispatcher().register(ZoneCommand.build());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder root = Commands.m_82127_((String)"zone");
        root.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"create").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)3, (int)128)).then(Commands.m_82129_((String)"points", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(ctx -> ZoneCommand.create((CommandContext<CommandSourceStack>)ctx, true)))).executes(ctx -> ZoneCommand.create((CommandContext<CommandSourceStack>)ctx, false)))));
        root.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).executes(ZoneCommand::remove)));
        root.then(Commands.m_82127_((String)"summary").executes(ZoneCommand::summary));
        return root;
    }

    private static int create(CommandContext<CommandSourceStack> ctx, boolean hasPoints) {
        int ppm;
        CommandSourceStack s = (CommandSourceStack)ctx.getSource();
        ServerLevel level = s.m_81372_();
        ZonesSavedData data = ZonesSavedData.get(level.m_7654_());
        String id = StringArgumentType.getString(ctx, (String)"id");
        int radius = IntegerArgumentType.getInteger(ctx, (String)"radius");
        int n = ppm = hasPoints ? IntegerArgumentType.getInteger(ctx, (String)"points") : 1;
        if (data.zones.containsKey(id)) {
            s.m_81352_((Component)Component.m_237113_((String)("Zone with id already exists: " + id)));
            return 0;
        }
        Vec3 pos3 = s.m_81371_();
        BlockPos pos = BlockPos.m_274561_((double)pos3.f_82479_, (double)pos3.f_82480_, (double)pos3.f_82481_);
        Zone z = new Zone(id, pos, radius, ppm);
        data.zones.put(id, z);
        data.m_77762_();
        s.m_288197_(() -> Component.m_237113_((String)("Zone " + id + " created at " + String.valueOf(pos) + ", r=" + radius + ", " + ppm + "/min")), true);
        return 1;
    }

    private static int remove(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack s = (CommandSourceStack)ctx.getSource();
        ZonesSavedData data = ZonesSavedData.get(s.m_81377_());
        String id = StringArgumentType.getString(ctx, (String)"id");
        if (data.zones.remove(id) != null) {
            data.m_77762_();
            s.m_288197_(() -> Component.m_237113_((String)("Zone " + id + " removed")), true);
            return 1;
        }
        s.m_81352_((Component)Component.m_237113_((String)("Zone not found: " + id)));
        return 0;
    }

    private static int summary(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack s = (CommandSourceStack)ctx.getSource();
        ZonesSavedData data = ZonesSavedData.get(s.m_81377_());
        MutableComponent msg = Component.m_237113_((String)("Tagil: " + String.valueOf(data.teamScores.getOrDefault("tagil", 0)) + "  |  USA: " + String.valueOf(data.teamScores.getOrDefault("usa", 0)) + "  |  ISIS: " + String.valueOf(data.teamScores.getOrDefault("isis", 0))));
        s.m_288197_(() -> msg, false);
        return 1;
    }
}

