/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.teams.client;

import com.fullfud.teams.Teams;
import com.fullfud.teams.client.ClientSelfData;
import com.fullfud.teams.client.ClientZoneData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ZoneWorldRenderer {
    private static final double MAX_DIST = 150.0;
    private static final int PANEL_W = 90;
    private static final int PANEL_H = 28;

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent e) {
        if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        PoseStack pose = e.getPoseStack();
        Camera cam = mc.f_91063_.m_109153_();
        Vec3 camPos = cam.m_90583_();
        for (ClientZoneData.ClientZone z : ClientZoneData.ZONES.values()) {
            boolean iCapture;
            double dz;
            double dy;
            BlockPos pos = z.pos;
            int groundY = mc.f_91073_.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
            double y = (double)groundY + 20.0;
            double dx = (double)pos.m_123341_() + 0.5 - camPos.f_82479_;
            double distSq = dx * dx + (dy = y - camPos.f_82480_) * dy + (dz = (double)pos.m_123343_() + 0.5 - camPos.f_82481_) * dz;
            if (distSq > 22500.0) continue;
            double dist = Math.sqrt(distSq);
            float t = (float)Math.min(1.0, dist / 150.0);
            float scale = 0.012f + 0.018f * t;
            pose.m_85836_();
            pose.m_85837_(dx, dy, dz);
            pose.m_252781_(Axis.f_252436_.m_252977_(-cam.m_90590_()));
            pose.m_252781_(Axis.f_252529_.m_252977_(cam.m_90589_()));
            pose.m_85841_(-scale, -scale, scale);
            ZoneWorldRenderer.fillRect(pose, -45, -14, 90, 28, -1342177280);
            ZoneWorldRenderer.drawRect(pose, -45, -14, 90, 28, 0x55FFFFFF);
            Font font = mc.f_91062_;
            String title = z.id + " (" + z.ppm + "/min)";
            int ownerColor = z.owner == null || z.owner.isEmpty() ? -2236963 : Teams.colorOf(z.owner);
            font.m_271703_(title, (float)(-font.m_92895_(title)) / 2.0f, -10.0f, ownerColor, false, pose.m_85850_().m_252922_(), (MultiBufferSource)mc.m_91269_().m_110104_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            boolean bl = iCapture = ClientSelfData.getTeam() != null && !ClientSelfData.getTeam().isEmpty() && ClientSelfData.getTeam().equals(z.capturing);
            if (iCapture) {
                String capText = "CAPTURING " + Math.round(z.progress) + "%";
                font.m_271703_(capText, (float)(-font.m_92895_(capText)) / 2.0f, -22.0f, Teams.colorOf(ClientSelfData.getTeam()), false, pose.m_85850_().m_252922_(), (MultiBufferSource)mc.m_91269_().m_110104_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            String label = "\u041f\u043e\u0434 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u0435\u043c: ";
            String teamName = Teams.displayNameOf(z.owner);
            int labelW = font.m_92895_(label);
            int teamW = font.m_92895_(teamName);
            float startX = (float)(-(labelW + teamW)) / 2.0f;
            font.m_271703_(label, startX, 2.0f, -1, false, pose.m_85850_().m_252922_(), (MultiBufferSource)mc.m_91269_().m_110104_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            int teamCol = z.owner == null || z.owner.isEmpty() ? -4473925 : Teams.colorOf(z.owner);
            font.m_271703_(teamName, startX + (float)labelW, 2.0f, teamCol, false, pose.m_85850_().m_252922_(), (MultiBufferSource)mc.m_91269_().m_110104_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            int barW = 78;
            int filled = Math.round((float)barW * (z.progress / 100.0f));
            int barX = -barW / 2;
            int barY = 12;
            ZoneWorldRenderer.fillRect(pose, barX, barY, barW, 4, 0x55222222);
            if (filled > 0) {
                int col = z.capturing == null || z.capturing.isEmpty() ? 0x55999999 : 0x55000000 | Teams.colorOf(z.capturing) & 0xFFFFFF;
                ZoneWorldRenderer.fillRect(pose, barX, barY, filled, 4, col);
            }
            mc.m_91269_().m_110104_().m_109911_();
            pose.m_85849_();
        }
    }

    private static void fillRect(PoseStack pose, int x, int y, int w, int h, int argb) {
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f m = pose.m_85850_().m_252922_();
        buf.m_252986_(m, (float)x, (float)y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(m, (float)x, (float)(y + h), 0.0f).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(m, (float)(x + w), (float)(y + h), 0.0f).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(m, (float)(x + w), (float)y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.disableBlend();
    }

    private static void drawRect(PoseStack pose, int x, int y, int w, int h, int argb) {
        ZoneWorldRenderer.fillRect(pose, x, y, w, 1, argb);
        ZoneWorldRenderer.fillRect(pose, x, y + h - 1, w, 1, argb);
        ZoneWorldRenderer.fillRect(pose, x, y, 1, h, argb);
        ZoneWorldRenderer.fillRect(pose, x + w - 1, y, 1, h, argb);
    }
}

