/*
 * Decompiled with CFR 0.152.
 */
package ru.warden;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import ru.warden.ClientboundUpdateThirdPersonStatePacket;
import ru.warden.Config;

@Mod(value="disable3person")
public class Distable3person {
    public static final String MODID = "disable3person";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("disable3person", "main_channel"), () -> "1", "1"::equals, "1"::equals);
    public static final GameRules.Key<GameRules.BooleanValue> DISABLE_THIRD_PERSON_GAMERULE = GameRules.m_46189_((String)"disableThirdPersonView", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46252_((boolean)false, (minecraftServer, value) -> {
        if (minecraftServer != null) {
            GameRules gameRules = minecraftServer.m_129900_();
            for (ServerPlayer player : minecraftServer.m_6846_().m_11314_()) {
                Distable3person.updateAndSendPlayerState(player, gameRules);
            }
        }
    }));
    public static final GameRules.Key<GameRules.BooleanValue> RESTRICT_OPS_THIRD_PERSON_VIEW = GameRules.m_46189_((String)"restrictOpsThirdPersonView", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46252_((boolean)false, (minecraftServer, value) -> {
        if (minecraftServer != null) {
            GameRules gameRules = minecraftServer.m_129900_();
            for (ServerPlayer player : minecraftServer.m_6846_().m_11314_()) {
                Distable3person.updateAndSendPlayerState(player, gameRules);
            }
        }
    }));

    public Distable3person() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        this.setupNetworking();
    }

    private void setupNetworking() {
        NETWORK_CHANNEL.registerMessage(0, ClientboundUpdateThirdPersonStatePacket.class, ClientboundUpdateThirdPersonStatePacket::encode, ClientboundUpdateThirdPersonStatePacket::new, ClientboundUpdateThirdPersonStatePacket::handle);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_8924_ == null) {
                return;
            }
            Distable3person.updateAndSendPlayerState(serverPlayer, serverPlayer.f_8924_.m_129900_());
        }
    }

    private static void updateAndSendPlayerState(ServerPlayer player, GameRules gameRules) {
        if (player.f_8924_ == null) {
            return;
        }
        boolean playerIsOp = player.f_8924_.m_6846_().m_11303_(player.m_36316_());
        boolean mainRuleActive = gameRules.m_46207_(DISABLE_THIRD_PERSON_GAMERULE);
        boolean restrictOpsRuleActive = gameRules.m_46207_(RESTRICT_OPS_THIRD_PERSON_VIEW);
        boolean shouldBeDisabledForPlayer = !mainRuleActive ? false : (playerIsOp ? restrictOpsRuleActive : true);
        NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundUpdateThirdPersonStatePacket(shouldBeDisabledForPlayer));
    }
}

