/*
 * Decompiled with CFR 0.152.
 */
package ru.warden;

import java.util.function.Supplier;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ru.warden.ClientSideThirdPersonState;

public class ClientboundUpdateThirdPersonStatePacket {
    private final boolean isDisabled;

    public ClientboundUpdateThirdPersonStatePacket(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public ClientboundUpdateThirdPersonStatePacket(FriendlyByteBuf buf) {
        this.isDisabled = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isDisabled);
    }

    public static void handle(ClientboundUpdateThirdPersonStatePacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            boolean previouslyDisabled = ClientSideThirdPersonState.isThirdPersonDisabled();
            ClientSideThirdPersonState.setThirdPersonDisabled(msg.isDisabled());
            if (!previouslyDisabled && msg.isDisabled()) {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91066_ != null && mc.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
                    mc.f_91066_.m_92157_(CameraType.FIRST_PERSON);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }
}

