/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.world.Lookup;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class GolemLookup
implements Lookup<EntityType<?>> {
    private final Map<String, Map<ResourceLocation, String>> substrates = new Object2ObjectLinkedOpenHashMap();

    @Override
    public String getAssociation(EntityType<?> key, String substrate) {
        Map<ResourceLocation, String> primitives = this.substrates.get(substrate);
        if (primitives == null) {
            primitives = this.substrates.get("");
        }
        if (primitives == null) {
            return "UNASSIGNED";
        }
        return primitives.getOrDefault(EntityType.m_20613_(key), "UNASSIGNED");
    }

    @Override
    public Set<String> getSubstrates() {
        return this.substrates.keySet();
    }

    @Override
    public void add(String key, String value) {
        String[] split = key.trim().split("@");
        String primitive = split[0];
        String substrate = split.length > 1 ? split[1] : "";
        this.substrates.computeIfAbsent(substrate, s -> new Object2ObjectLinkedOpenHashMap()).put(new ResourceLocation(primitive), value);
    }

    @Override
    public boolean contains(EntityType<?> key) {
        ResourceLocation primitive = EntityType.m_20613_(key);
        for (Map<ResourceLocation, String> primitives : this.substrates.values()) {
            if (!primitives.containsKey(primitive)) continue;
            return true;
        }
        return false;
    }
}

