/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.schedule;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import snownee.kiwi.Kiwi;
import snownee.kiwi.schedule.ITicker;
import snownee.kiwi.schedule.Task;

@Mod.EventBusSubscriber
public final class Scheduler
extends SavedData {
    public static final String ID = "kiwi-schedule";
    public static final Scheduler INSTANCE = new Scheduler();
    private static final BiMap<ResourceLocation, Class<Task>> idMap = HashBiMap.create();
    protected static final Multimap<ITicker, Task> taskMap = LinkedListMultimap.create();

    private Scheduler() {
    }

    public static void register(ResourceLocation id, Class<? extends Task> clazz) {
        if (idMap.containsKey((Object)id)) {
            Kiwi.LOGGER.error("Duplicate task id: " + id);
        } else if (idMap.containsValue(clazz)) {
            Kiwi.LOGGER.error("Duplicate task class: " + clazz);
        } else if (!INBTSerializable.class.isAssignableFrom(clazz)) {
            Kiwi.LOGGER.error("task " + id + " should implement INBTSerializable");
        } else {
            idMap.put((Object)id, clazz);
        }
    }

    public static Task deserialize(CompoundTag data) {
        try {
            ResourceLocation type = new ResourceLocation(data.m_128461_("type"));
            Class clazz = (Class)idMap.get((Object)type);
            if (clazz != null) {
                Task task = (Task)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ((INBTSerializable)task).deserializeNBT((Tag)data);
                return task;
            }
        }
        catch (Exception e) {
            Kiwi.LOGGER.error("Failed to deserialize task %s".formatted(data), (Throwable)e);
        }
        return null;
    }

    public CompoundTag serialize(Task task) {
        if (task.shouldSave()) {
            try {
                ResourceLocation type = (ResourceLocation)idMap.inverse().get(task.getClass());
                CompoundTag data = (CompoundTag)((INBTSerializable)task).serializeNBT();
                data.m_128359_("type", type.toString());
                return data;
            }
            catch (Exception e) {
                Kiwi.LOGGER.error("Failed to serialize task %s".formatted(task), (Throwable)e);
            }
        }
        return null;
    }

    public static void add(Task<?> task) {
        Object ticker = task.ticker();
        if (ticker != null) {
            taskMap.put(ticker, task);
        }
    }

    public static void remove(Task<?> task) {
        taskMap.values().remove(task);
    }

    public static <T extends ITicker> void tick(T ticker) {
        Iterator itr = taskMap.get(ticker).iterator();
        while (itr.hasNext()) {
            Task task = (Task)itr.next();
            if (!task.tick(ticker)) continue;
            itr.remove();
        }
    }

    public boolean m_77764_() {
        return !taskMap.isEmpty();
    }

    public static Scheduler load(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("tasks", 10);
        for (int i = 0; i < list.size(); ++i) {
            Task task = Scheduler.deserialize(list.m_128728_(i));
            if (task == null) continue;
            Scheduler.add(task);
        }
        return INSTANCE;
    }

    public CompoundTag m_7176_(CompoundTag data) {
        ListTag list = new ListTag();
        for (Task task : taskMap.values()) {
            CompoundTag nbt = this.serialize(task);
            if (nbt == null) continue;
            list.add((Object)nbt);
        }
        if (!list.isEmpty()) {
            data.m_128365_("tasks", (Tag)list);
        }
        return data;
    }

    public static void clear() {
        taskMap.keySet().forEach(ITicker::destroy);
        taskMap.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        Scheduler.clear();
    }

    @SubscribeEvent
    public static void serverStopped(ServerStoppedEvent event) {
        Scheduler.clear();
    }
}

