/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;

public record MouldingComponent() implements KBlockComponent
{
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    private static final MouldingComponent INSTANCE = new MouldingComponent();

    public static MouldingComponent getInstance() {
        return INSTANCE;
    }

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.MOULDING.getOrCreate();
    }

    @Override
    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE});
    }

    @Override
    public BlockState registerDefaultState(BlockState state) {
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT);
    }

    @Override
    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    private StairsShape getShapeAt(BlockState ourState, BlockGetter pLevel, BlockPos pPos) {
        Direction theirFacing;
        Direction ourFacing = (Direction)ourState.m_61143_((Property)FACING);
        BlockState theirState = pLevel.m_8055_(pPos.m_121945_(ourFacing));
        if (this.canBeConnected(ourState, theirState) && (theirFacing = (Direction)theirState.m_61143_((Property)FACING)).m_122434_() != ourFacing.m_122434_() && this.canTakeShape(ourState, pLevel, pPos, theirFacing.m_122424_())) {
            if (theirFacing == ourFacing.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        theirState = pLevel.m_8055_(pPos.m_121945_(ourFacing.m_122424_()));
        if (this.canBeConnected(ourState, theirState) && (theirFacing = (Direction)theirState.m_61143_((Property)FACING)).m_122434_() != ourFacing.m_122434_() && this.canTakeShape(ourState, pLevel, pPos, theirFacing)) {
            if (theirFacing == ourFacing.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private boolean canTakeShape(BlockState ourState, BlockGetter pLevel, BlockPos pPos, Direction pFace) {
        BlockState blockState = pLevel.m_8055_(pPos.m_121945_(pFace));
        return !this.canBeConnected(ourState, blockState) || blockState.m_61143_((Property)FACING) != ourState.m_61143_((Property)FACING);
    }

    private boolean canBeConnected(BlockState ourState, BlockState theirState) {
        return ourState.m_60713_(theirState.m_60734_());
    }

    @Override
    public BlockState getStateForPlacement(KBlockSettings settings, BlockState state, BlockPlaceContext context) {
        if (settings.customPlacement) {
            return state;
        }
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_());
        if ((blockstate = (BlockState)blockstate.m_61124_(SHAPE, (Comparable)this.getShapeAt(blockstate, (BlockGetter)context.m_43725_(), blockpos))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
            return blockstate;
        }
        return null;
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection.m_122434_().m_122479_()) {
            pState = (BlockState)pState.m_61124_(SHAPE, (Comparable)this.getShapeAt(pState, (BlockGetter)pLevel, pPos));
        }
        return pState;
    }

    @Override
    @Nullable
    public Direction getHorizontalFacing(BlockState blockState) {
        if (blockState.m_61143_(SHAPE) == StairsShape.STRAIGHT) {
            return ((Direction)blockState.m_61143_((Property)FACING)).m_122424_();
        }
        return null;
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)pState.m_61143_(SHAPE);
        switch (pMirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                return switch (stairsshape) {
                    default -> throw new IncompatibleClassChangeError();
                    case StairsShape.INNER_LEFT -> (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> pState.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                return switch (stairsshape) {
                    default -> throw new IncompatibleClassChangeError();
                    case StairsShape.INNER_LEFT -> (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> pState.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
        }
        return pState;
    }
}

