/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.waypoints;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.hudcompass.ConfigData;
import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.network.AddWaypoint;
import dev.gigaherz.hudcompass.network.RemoveWaypoint;
import dev.gigaherz.hudcompass.network.SyncWaypointData;
import dev.gigaherz.hudcompass.network.UpdateWaypointsFromGui;
import dev.gigaherz.hudcompass.waypoints.BasicWaypoint;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointInfoRegistry;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointsOfInterest {
    public static Capability<PointsOfInterest> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<PointsOfInterest>(){});
    private PointInfo<?> targetted;
    public int changeNumber;
    public int savedNumber;
    private final Map<ResourceLocation, Object> addonData = Maps.newHashMap();
    private List<Runnable> listeners = Lists.newArrayList();
    private static final ResourceLocation PROVIDER_KEY = HudCompass.location("poi_provider");
    private final Set<PointInfo<?>> changed = Sets.newHashSet();
    private final Set<PointInfo<?>> removed = Sets.newHashSet();
    private final Map<ResourceKey<Level>, WorldPoints> perWorld = Maps.newHashMap();
    private Player player;
    public boolean otherSideHasMod = false;

    public <T> T getOrCreateAddonData(ResourceLocation addonId, Supplier<T> factory) {
        return (T)this.addonData.computeIfAbsent(addonId, key -> factory.get());
    }

    public static void init(RegisterCapabilitiesEvent event) {
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, PointsOfInterest::attachEvent);
        MinecraftForge.EVENT_BUS.addListener(PointsOfInterest::playerClone);
        event.register(PointsOfInterest.class);
    }

    private static void attachEvent(AttachCapabilitiesEvent<Entity> event) {
        final Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            event.addCapability(PROVIDER_KEY, (ICapabilityProvider)new ICapabilitySerializable<ListTag>(){
                private final PointsOfInterest poi = new PointsOfInterest();
                private final LazyOptional<PointsOfInterest> poiSupplier = LazyOptional.of(() -> this.poi);
                {
                    this.poi.setPlayer((Player)entity);
                }

                public ListTag serializeNBT() {
                    return this.poi.write();
                }

                public void deserializeNBT(ListTag nbt) {
                    this.poi.read(nbt);
                }

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    if (cap == INSTANCE) {
                        return this.poiSupplier.cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }

    private static void playerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        Player newPlayer = event.getEntity();
        newPlayer.getCapability(INSTANCE).ifPresent(newPois -> oldPlayer.getCapability(INSTANCE).ifPresent(oldPois -> newPois.transferFrom((PointsOfInterest)oldPois)));
    }

    private void transferFrom(PointsOfInterest oldPois) {
        for (WorldPoints w : oldPois.getAllWorlds()) {
            this.get(w.worldKey, w.dimensionTypeKey).transferFrom(w);
        }
    }

    public static void onTick(Player player) {
        player.getCapability(INSTANCE).ifPresent(PointsOfInterest::tick);
    }

    public Collection<WorldPoints> getAllWorlds() {
        return Collections.unmodifiableCollection(this.perWorld.values());
    }

    public ListTag write() {
        ListTag list = new ListTag();
        for (Map.Entry<ResourceKey<Level>, WorldPoints> entry : this.perWorld.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("World", entry.getKey().m_135782_().toString());
            if (entry.getValue().getDimensionTypeKey() != null) {
                tag.m_128359_("DimensionKey", entry.getValue().getDimensionTypeKey().m_135782_().toString());
            }
            tag.m_128365_("POIs", (Tag)entry.getValue().write());
            list.add((Object)tag);
        }
        return list;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.perWorld.size());
        for (Map.Entry<ResourceKey<Level>, WorldPoints> entry : this.perWorld.entrySet()) {
            ResourceKey<Level> key = entry.getKey();
            WorldPoints value = entry.getValue();
            buffer.m_130085_(key.m_135782_());
            if (value.getDimensionTypeKey() != null) {
                buffer.writeBoolean(true);
                buffer.m_130085_(value.getDimensionTypeKey().m_135782_());
            } else {
                buffer.writeBoolean(false);
            }
            value.write(buffer);
        }
    }

    public void read(ListTag nbt) {
        this.perWorld.clear();
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag tag = nbt.m_128728_(i);
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("World")));
            ResourceKey dimType = null;
            if (tag.m_128425_("DimensionKey", 8)) {
                dimType = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation(tag.m_128461_("DimensionKey")));
            }
            WorldPoints p = this.get((ResourceKey<Level>)key, dimType);
            p.read(tag.m_128437_("POIs", 10));
        }
        this.changeNumber = 0;
        this.savedNumber = 0;
    }

    public void read(FriendlyByteBuf buffer) {
        this.perWorld.values().forEach(pt -> pt.points.values().removeIf(PointInfo::isServerManaged));
        int numWorlds = buffer.m_130242_();
        for (int i = 0; i < numWorlds; ++i) {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_());
            boolean hasDimensionType = buffer.readBoolean();
            ResourceKey dimType = hasDimensionType ? ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)buffer.m_130281_()) : null;
            WorldPoints p = this.get((ResourceKey<Level>)key, (ResourceKey<DimensionType>)dimType);
            p.read(buffer);
        }
        this.changeNumber = 0;
        this.savedNumber = 0;
    }

    public void clear() {
        this.perWorld.values().forEach(WorldPoints::clear);
        this.perWorld.clear();
    }

    public void setTargetted(@Nullable PointInfo<?> targetted) {
        this.targetted = targetted;
    }

    public PointInfo<?> getTargetted() {
        return this.targetted;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void tick() {
        this.perWorld.values().forEach(WorldPoints::tick);
    }

    private void sendInitialSync() {
        this.sendSync();
    }

    private void sendSync() {
        if (((Boolean)ConfigData.COMMON.disableServerHello.get()).booleanValue()) {
            return;
        }
        if (this.otherSideHasMod) {
            HudCompass.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new SyncWaypointData(this));
        }
    }

    private void sendUpdateFromGui(ImmutableList<Pair<ResourceLocation, PointInfo<?>>> toAdd, ImmutableList<Pair<ResourceLocation, PointInfo<?>>> toUpdate, ImmutableList<UUID> toRemove) {
        HudCompass.channel.sendToServer((Object)new UpdateWaypointsFromGui(toAdd, toUpdate, toRemove));
    }

    public static void handleAddWaypoint(ServerPlayer sender, AddWaypoint addWaypoint) {
        sender.getCapability(INSTANCE).ifPresent(points -> {
            BasicWaypoint waypoint = new BasicWaypoint(new Vec3(addWaypoint.x, addWaypoint.y, addWaypoint.z), addWaypoint.label, addWaypoint.isMarker ? BasicIconData.mapMarker(addWaypoint.iconIndex) : BasicIconData.poi(addWaypoint.iconIndex));
            points.get(sender.m_9236_()).addPoint(waypoint);
        });
    }

    public void updateFromGui(ImmutableList<Pair<ResourceLocation, PointInfo<?>>> toAdd, ImmutableList<Pair<ResourceLocation, PointInfo<?>>> toUpdate, ImmutableList<UUID> toRemove) {
        if (this.player.m_9236_().f_46443_ && this.otherSideHasMod) {
            this.sendUpdateFromGui(toAdd, toUpdate, toRemove);
        } else {
            this.applyUpdatesFromGui(toAdd, toUpdate, toRemove);
        }
    }

    public WorldPoints get(Level world) {
        return this.getInternal((ResourceKey<Level>)world.m_46472_(), () -> PointsOfInterest.getDimensionTypeKey(world, null));
    }

    public WorldPoints get(ResourceKey<Level> worldKey) {
        return this.get(worldKey, null);
    }

    public WorldPoints get(ResourceKey<Level> worldKey, @Nullable ResourceKey<DimensionType> dimensionTypeKey) {
        return this.getInternal(worldKey, () -> {
            if (this.player.m_9236_().m_46472_() == worldKey) {
                return PointsOfInterest.getDimensionTypeKey(this.player.m_9236_(), dimensionTypeKey);
            }
            MinecraftServer server = this.player.m_9236_().m_7654_();
            if (server == null) {
                return dimensionTypeKey;
            }
            ServerLevel world = server.m_129880_(worldKey);
            if (world == null) {
                return dimensionTypeKey;
            }
            return PointsOfInterest.getDimensionTypeKey((Level)world, dimensionTypeKey);
        });
    }

    @Nullable
    private static ResourceKey<DimensionType> getDimensionTypeKey(Level world, @Nullable ResourceKey<DimensionType> fallback) {
        DimensionType dimType = world.m_6042_();
        ResourceLocation key = world.m_9598_().m_175515_(Registries.f_256787_).m_7981_((Object)dimType);
        if (key == null) {
            return fallback;
        }
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)key);
    }

    private WorldPoints getInternal(ResourceKey<Level> worldKey, Supplier<ResourceKey<DimensionType>> dimensionTypeKey) {
        return this.perWorld.computeIfAbsent(Objects.requireNonNull(worldKey), worldKey1 -> new WorldPoints((ResourceKey<Level>)worldKey1, (ResourceKey<DimensionType>)((ResourceKey)dimensionTypeKey.get())));
    }

    public static void handleRemoveWaypoint(ServerPlayer sender, RemoveWaypoint removeWaypoint) {
        sender.getCapability(INSTANCE).ifPresent(points -> points.find(removeWaypoint.id).ifPresent(pt -> {
            WorldPoints owner;
            if (!pt.isDynamic() && (owner = pt.getOwner()) != null) {
                owner.removePoint(removeWaypoint.id);
            }
        }));
    }

    private Optional<PointInfo<?>> find(UUID id) {
        return this.perWorld.values().stream().flatMap(world -> world.find(id).stream()).findAny();
    }

    private void remove(UUID pt) {
        this.getAllWorlds().forEach(w -> w.removePoint(pt));
    }

    public static void handleSync(Player player, byte[] packet) {
        player.getCapability(INSTANCE).ifPresent(points -> points.read(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])packet))));
    }

    public static void handleUpdateFromGui(ServerPlayer sender, UpdateWaypointsFromGui packet) {
        sender.getCapability(INSTANCE).ifPresent(points -> {
            ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsAdded = packet.pointsAdded;
            ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsUpdated = packet.pointsUpdated;
            ImmutableList<UUID> pointsRemoved = packet.pointsRemoved;
            points.applyUpdatesFromGui(pointsAdded, pointsUpdated, pointsRemoved);
        });
    }

    private void applyUpdatesFromGui(ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsAdded, ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsUpdated, ImmutableList<UUID> pointsRemoved) {
        for (UUID pt : pointsRemoved) {
            this.remove(pt);
        }
        for (UUID pt : pointsAdded) {
            this.get((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)((ResourceLocation)pt.getFirst()))).addPoint((PointInfo)pt.getSecond());
        }
        for (UUID pt : pointsUpdated) {
            this.get((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)((ResourceLocation)pt.getFirst()))).addPoint((PointInfo)pt.getSecond());
        }
    }

    public static void remoteHello(@Nullable Player player) {
        if (player == null) {
            return;
        }
        player.getCapability(INSTANCE).ifPresent(points -> {
            points.otherSideHasMod = true;
            if (!player.m_9236_().f_46443_) {
                points.sendInitialSync();
            }
        });
    }

    public void addListener(Runnable onSyncReceived) {
        this.listeners.add(onSyncReceived);
    }

    public void removeListener(Runnable onSyncReceived) {
        this.listeners.remove(onSyncReceived);
    }

    public class WorldPoints {
        private final ResourceKey<Level> worldKey;
        @Nullable
        private final ResourceKey<DimensionType> dimensionTypeKey;
        private final Map<UUID, PointInfo<?>> points = Maps.newHashMap();

        public WorldPoints(@Nullable ResourceKey<Level> worldKey, ResourceKey<DimensionType> dimensionTypeKey) {
            this.worldKey = worldKey;
            this.dimensionTypeKey = dimensionTypeKey;
        }

        public Collection<PointInfo<?>> getPoints() {
            return this.points.values();
        }

        private void tick() {
            for (PointInfo<?> point : this.points.values()) {
                point.tick(PointsOfInterest.this.player);
            }
            if (PointsOfInterest.this.player.m_9236_().f_46443_ && PointsOfInterest.this.player.m_9236_().m_46472_() == this.worldKey) {
                PointInfo<?> closest = null;
                double closestAngle = Double.POSITIVE_INFINITY;
                for (PointInfo<?> point : this.points.values()) {
                    double m2;
                    Vec3 direction = point.getPosition(PointsOfInterest.this.player, 1.0f).m_82546_(PointsOfInterest.this.player.m_20182_());
                    Vec3 look = PointsOfInterest.this.player.m_20154_();
                    direction = direction.m_82541_();
                    look = look.m_82541_();
                    double dot = direction.f_82479_ * look.f_82479_ + direction.f_82481_ * look.f_82481_;
                    double m1 = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
                    double angle = Math.abs(Math.acos(dot / (m1 * (m2 = Math.sqrt(look.f_82479_ * look.f_82479_ + look.f_82481_ * look.f_82481_)))));
                    if (!(angle < closestAngle)) continue;
                    closest = point;
                    closestAngle = angle;
                }
                if (closest != null && closestAngle < Math.toRadians(15.0)) {
                    PointsOfInterest.this.setTargetted(closest);
                } else {
                    PointsOfInterest.this.setTargetted(null);
                }
            }
            if (!(PointsOfInterest.this.player.m_9236_().f_46443_ || PointsOfInterest.this.changed.size() <= 0 && PointsOfInterest.this.removed.size() <= 0)) {
                PointsOfInterest.this.sendSync();
                PointsOfInterest.this.changed.clear();
                PointsOfInterest.this.removed.clear();
            }
        }

        public void addPointRequest(PointInfo<?> point) {
            if (PointsOfInterest.this.otherSideHasMod && PointsOfInterest.this.player.m_9236_().f_46443_ && point instanceof BasicWaypoint) {
                HudCompass.channel.sendToServer((Object)new AddWaypoint((BasicWaypoint)point));
            } else {
                this.addPoint(point);
            }
        }

        public void addPoint(PointInfo<?> point) {
            point.setOwner(this);
            PointInfo<?> oldPoint = this.points.put(point.getInternalId(), point);
            if (oldPoint != null) {
                oldPoint.setOwner(null);
            }
            if (!PointsOfInterest.this.player.m_9236_().f_46443_ && PointsOfInterest.this.otherSideHasMod) {
                PointsOfInterest.this.changed.add(point);
            }
            if (!point.isDynamic()) {
                ++PointsOfInterest.this.changeNumber;
            }
        }

        public void removePointRequest(PointInfo<?> point) {
            UUID id = point.getInternalId();
            if (PointsOfInterest.this.otherSideHasMod && PointsOfInterest.this.player.m_9236_().f_46443_) {
                HudCompass.channel.sendToServer((Object)new RemoveWaypoint(id));
            } else {
                this.removePoint(id);
            }
        }

        public void removePoint(PointInfo<?> point) {
            this.removePoint(point.getInternalId());
        }

        public void removePoint(UUID id) {
            PointInfo<?> point = this.points.get(id);
            if (point != null) {
                point.setOwner(null);
                this.points.remove(point.getInternalId());
                if (!PointsOfInterest.this.player.m_9236_().f_46443_ && PointsOfInterest.this.otherSideHasMod) {
                    PointsOfInterest.this.removed.add(point);
                }
                if (!point.isDynamic()) {
                    ++PointsOfInterest.this.changeNumber;
                }
            }
        }

        public void clear() {
            boolean nonDynamic = this.points.values().stream().anyMatch(point -> !point.isDynamic());
            PointsOfInterest.this.removed.addAll(this.points.values());
            this.points.clear();
            if (nonDynamic) {
                ++PointsOfInterest.this.changeNumber;
            }
        }

        public void markDirty(PointInfo<?> point) {
            if (!PointsOfInterest.this.player.m_9236_().f_46443_ && PointsOfInterest.this.otherSideHasMod) {
                PointsOfInterest.this.changed.add(point);
            }
            if (!point.isDynamic()) {
                ++PointsOfInterest.this.changeNumber;
            }
        }

        public ListTag write() {
            ListTag tag = new ListTag();
            for (PointInfo<?> point : this.points.values()) {
                if (point.isDynamic()) continue;
                tag.add((Object)PointInfoRegistry.serializePoint(point));
            }
            return tag;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130130_(this.points.size());
            for (PointInfo<?> point : this.points.values()) {
                PointInfoRegistry.serializePoint(point, buffer);
            }
        }

        public void read(ListTag nbt) {
            this.points.clear();
            for (int i = 0; i < nbt.size(); ++i) {
                CompoundTag pointTag = nbt.m_128728_(i);
                PointInfo<?> point = PointInfoRegistry.deserializePoint(pointTag);
                this.points.put(point.getInternalId(), point);
            }
        }

        public void read(FriendlyByteBuf buffer) {
            this.points.values().removeIf(pointInfo -> pointInfo.isServerManaged());
            int numPoints = buffer.m_130242_();
            for (int i = 0; i < numPoints; ++i) {
                PointInfo<?> point = PointInfoRegistry.deserializePoint(buffer);
                this.points.put(point.getInternalId(), point);
            }
        }

        public ResourceKey<Level> getWorldKey() {
            return this.worldKey;
        }

        @Nullable
        public ResourceKey<DimensionType> getDimensionTypeKey() {
            return this.dimensionTypeKey;
        }

        public Optional<PointInfo<?>> find(UUID id) {
            return Optional.ofNullable(this.points.get(id));
        }

        public void transferFrom(WorldPoints w) {
            for (PointInfo<?> p : w.getPoints()) {
                this.addPoint(p);
            }
        }
    }
}

