/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.waypoints;

import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class PointInfoRegistry {
    @Nonnull
    public static <T extends PointInfo<T>> CompoundTag serializePoint(@Nonnull T pointInfo) {
        PointInfoType<T> type = pointInfo.getType();
        ResourceLocation typeId = HudCompass.POINT_INFO_TYPES_REGISTRY.get().getKey(type);
        if (typeId == null) {
            throw new IllegalStateException(String.format("Serializer name is null %s", type.getClass().getName()));
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", typeId.toString());
        return pointInfo.write(tag);
    }

    public static <T extends PointInfo<T>> void serializePoint(T pointInfo, FriendlyByteBuf buffer) {
        PointInfoType<T> type = pointInfo.getType();
        buffer.writeRegistryIdUnsafe(HudCompass.POINT_INFO_TYPES_REGISTRY.get(), type);
        pointInfo.writeToPacket(buffer);
    }

    public static <T extends PointInfo<T>> void serializePointWithoutId(T pointInfo, FriendlyByteBuf buffer) {
        PointInfoType<T> type = pointInfo.getType();
        buffer.writeRegistryIdUnsafe(HudCompass.POINT_INFO_TYPES_REGISTRY.get(), type);
        pointInfo.writeToPacketWithoutId(buffer);
    }

    @Nonnull
    public static PointInfo<?> deserializePoint(CompoundTag tag) {
        ResourceLocation typeId = new ResourceLocation(tag.m_128461_("Type"));
        PointInfoType type = (PointInfoType)HudCompass.POINT_INFO_TYPES_REGISTRY.get().getValue(typeId);
        if (type == null) {
            throw new IllegalStateException(String.format("Serializer not registered %s", typeId));
        }
        Object info = type.create();
        ((PointInfo)info).read(tag);
        return info;
    }

    @Nonnull
    public static PointInfo<?> deserializePoint(FriendlyByteBuf buffer) {
        PointInfoType serializer = (PointInfoType)buffer.readRegistryIdUnsafe(HudCompass.POINT_INFO_TYPES_REGISTRY.get());
        if (serializer == null) {
            throw new IllegalStateException("Server returned unknown serializer");
        }
        Object info = serializer.create();
        ((PointInfo)info).readFromPacket(buffer);
        return info;
    }

    @Nonnull
    public static PointInfo<?> deserializePointWithoutId(FriendlyByteBuf buffer) {
        PointInfoType serializer = (PointInfoType)buffer.readRegistryIdUnsafe(HudCompass.POINT_INFO_TYPES_REGISTRY.get());
        if (serializer == null) {
            throw new IllegalStateException("Server returned unknown serializer");
        }
        Object info = serializer.create();
        ((PointInfo)info).readFromPacketWithoutId(buffer);
        return info;
    }
}

