/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.waypoints;

import dev.gigaherz.hudcompass.icons.IIconData;
import dev.gigaherz.hudcompass.icons.IconDataRegistry;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public abstract class PointInfo<T extends PointInfo<T>> {
    private final PointInfoType<? extends T> type;
    @Nullable
    private PointsOfInterest.WorldPoints owner;
    private UUID internalId;
    @Nullable
    private Component label;
    private IIconData<?> iconData;
    private boolean displayVerticalDistance = true;
    private boolean isServerProvided = true;
    private boolean isDynamic;
    public float fade;

    public PointInfo(PointInfoType<? extends T> type, boolean isDynamic) {
        this.isDynamic = isDynamic;
        this.type = type;
        this.internalId = UUID.randomUUID();
    }

    public PointInfo(PointInfoType<T> type, boolean isDynamic, @Nullable Component label, IIconData<?> iconData) {
        this(type, isDynamic);
        this.label = label;
        this.iconData = iconData;
    }

    public PointInfoType<? extends T> getType() {
        return this.type;
    }

    @Nullable
    public final PointsOfInterest.WorldPoints getOwner() {
        return this.owner;
    }

    public UUID getInternalId() {
        return this.internalId;
    }

    public void setInternalId(UUID uuid) {
        this.internalId = uuid;
    }

    public abstract Vec3 getPosition();

    public abstract Vec3 getPosition(Player var1, float var2);

    @Nullable
    public Component getLabel() {
        return this.label;
    }

    public void setLabel(@Nullable Component text) {
        if (!Objects.equals(this.label, text)) {
            this.markDirty();
        }
        this.label = text;
    }

    public IIconData<?> getIconData() {
        return this.iconData;
    }

    protected void setIconData(IIconData<?> iconData) {
        this.iconData = iconData;
    }

    public T dynamic() {
        this.isDynamic = true;
        return (T)this;
    }

    public final T noVerticalDistance() {
        this.displayVerticalDistance = false;
        return (T)this;
    }

    public boolean displayVerticalDistance(Player player) {
        return this.displayVerticalDistance;
    }

    public void clientPoint() {
        this.isServerProvided = false;
    }

    public boolean isServerManaged() {
        return this.isServerProvided;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void tick(Player player) {
    }

    void setOwner(@Nullable PointsOfInterest.WorldPoints owner) {
        this.owner = owner;
    }

    public void markDirty() {
        if (this.owner != null) {
            this.owner.markDirty(this);
        }
    }

    public final CompoundTag write(CompoundTag tag) {
        tag.m_128359_("ID", this.internalId.toString());
        if (this.label != null) {
            tag.m_128359_("Label", Component.Serializer.m_130703_((Component)this.label));
        }
        tag.m_128365_("Icon", (Tag)IconDataRegistry.serializeIcon(this.iconData));
        tag.m_128379_("DisplayVerticalDistance", this.displayVerticalDistance);
        this.serializeAdditional(tag);
        return tag;
    }

    public final void read(CompoundTag tag) {
        this.internalId = UUID.fromString(tag.m_128461_("ID"));
        this.label = tag.m_128425_("Label", 8) ? Component.Serializer.m_130701_((String)tag.m_128461_("Label")) : null;
        this.iconData = IconDataRegistry.deserializeIcon(tag.m_128469_("Icon"));
        this.displayVerticalDistance = tag.m_128471_("DisplayVerticalDistance");
        this.deserializeAdditional(tag);
    }

    public final void writeToPacket(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.internalId);
        this.writeToPacketWithoutId(buffer);
    }

    public final void writeToPacketWithoutId(FriendlyByteBuf buffer) {
        boolean hasLabel = this.label != null;
        buffer.writeBoolean(hasLabel);
        if (hasLabel) {
            buffer.m_130083_(this.label);
        }
        IconDataRegistry.serializeIcon(this.iconData, buffer);
        buffer.writeBoolean(this.displayVerticalDistance);
        buffer.writeBoolean(this.isDynamic);
        this.serializeAdditional(buffer);
    }

    public final void readFromPacket(FriendlyByteBuf buffer) {
        this.internalId = buffer.m_130259_();
        this.readFromPacketWithoutId(buffer);
    }

    public final void readFromPacketWithoutId(FriendlyByteBuf buffer) {
        boolean hasLabel = buffer.readBoolean();
        this.label = hasLabel ? buffer.m_130238_() : null;
        this.iconData = IconDataRegistry.deserializeIcon(buffer);
        this.displayVerticalDistance = buffer.readBoolean();
        this.isDynamic = buffer.readBoolean();
        this.deserializeAdditional(buffer);
    }

    protected abstract void serializeAdditional(CompoundTag var1);

    protected abstract void deserializeAdditional(CompoundTag var1);

    protected abstract void serializeAdditional(FriendlyByteBuf var1);

    protected abstract void deserializeAdditional(FriendlyByteBuf var1);
}

