/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.waypoints;

import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.icons.IIconData;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class BasicWaypoint
extends PointInfo<BasicWaypoint> {
    private String label;
    private Vec3 position;

    public BasicWaypoint() {
        super((PointInfoType)HudCompass.BASIC_WAYPOINT.get(), false);
    }

    public BasicWaypoint(BlockPos exactPosition, @Nullable String label, IIconData<?> iconData) {
        this(Vec3.m_82512_((Vec3i)exactPosition), label, iconData);
    }

    public BasicWaypoint(Vec3 exactPosition, @Nullable String label, IIconData<?> iconData) {
        this((PointInfoType)HudCompass.BASIC_WAYPOINT.get(), exactPosition, label, iconData);
    }

    public BasicWaypoint(PointInfoType<BasicWaypoint> type, Vec3 exactPosition, @Nullable String label, IIconData<?> iconData) {
        super(type, false, (Component)(label == null ? null : Component.m_237113_((String)label)), iconData);
        this.position = exactPosition;
        this.label = label == null ? "" : label;
    }

    @Override
    public Vec3 getPosition() {
        return this.position;
    }

    @Override
    public Vec3 getPosition(Player player, float partialTicks) {
        return this.position;
    }

    public void setPosition(Vec3 position) {
        if (Mth.m_14082_((double)position.m_82557_(position), (double)0.0)) {
            this.position = position;
            this.markDirty();
        }
    }

    public String getLabelText() {
        return this.label;
    }

    public void setLabelText(String label) {
        this.label = Objects.requireNonNull(label);
        super.setLabel((Component)(label.length() > 0 ? Component.m_237113_((String)label) : null));
    }

    @Override
    protected void serializeAdditional(CompoundTag tag) {
        tag.m_128347_("X", this.position.f_82479_);
        tag.m_128347_("Y", this.position.f_82480_);
        tag.m_128347_("Z", this.position.f_82481_);
        tag.m_128359_("Text", this.label);
    }

    @Override
    protected void deserializeAdditional(CompoundTag tag) {
        this.position = new Vec3(tag.m_128459_("X"), tag.m_128459_("Y"), tag.m_128459_("Z"));
        this.label = tag.m_128461_("Text");
    }

    @Override
    protected void serializeAdditional(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.position.f_82479_);
        buffer.writeDouble(this.position.f_82480_);
        buffer.writeDouble(this.position.f_82481_);
        buffer.m_130072_(this.label, 1024);
    }

    @Override
    protected void deserializeAdditional(FriendlyByteBuf buffer) {
        this.position = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.label = buffer.m_130136_(1024);
    }
}

