/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.network;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointInfoRegistry;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class UpdateWaypointsFromGui {
    public final ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsAdded;
    public final ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsUpdated;
    public final ImmutableList<UUID> pointsRemoved;

    public UpdateWaypointsFromGui(ImmutableList<Pair<ResourceLocation, PointInfo<?>>> added, ImmutableList<Pair<ResourceLocation, PointInfo<?>>> updated, ImmutableList<UUID> removed) {
        this.pointsAdded = added;
        this.pointsUpdated = updated;
        this.pointsRemoved = removed;
    }

    public UpdateWaypointsFromGui(FriendlyByteBuf buffer) {
        ImmutableList.Builder toAdd = ImmutableList.builder();
        ImmutableList.Builder toUpdate = ImmutableList.builder();
        ImmutableList.Builder toRemove = ImmutableList.builder();
        int numberToAdd = buffer.m_130242_();
        for (int i = 0; i < numberToAdd; ++i) {
            ResourceLocation id = buffer.m_130281_();
            PointInfo<?> pt = PointInfoRegistry.deserializePointWithoutId(buffer);
            toAdd.add((Object)Pair.of((Object)id, pt));
        }
        int numberToUpdate = buffer.m_130242_();
        for (int i = 0; i < numberToUpdate; ++i) {
            ResourceLocation id = buffer.m_130281_();
            PointInfo<?> pt = PointInfoRegistry.deserializePoint(buffer);
            toUpdate.add((Object)Pair.of((Object)id, pt));
        }
        int numberToRemove = buffer.m_130242_();
        for (int i = 0; i < numberToRemove; ++i) {
            toRemove.add((Object)buffer.m_130259_());
        }
        this.pointsAdded = toAdd.build();
        this.pointsUpdated = toUpdate.build();
        this.pointsRemoved = toRemove.build();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.pointsAdded.size());
        this.pointsAdded.forEach(pt -> {
            buffer.m_130085_((ResourceLocation)pt.getFirst());
            PointInfoRegistry.serializePointWithoutId((PointInfo)pt.getSecond(), buffer);
        });
        buffer.m_130130_(this.pointsUpdated.size());
        this.pointsUpdated.forEach(pt -> {
            buffer.m_130085_((ResourceLocation)pt.getFirst());
            PointInfoRegistry.serializePoint((PointInfo)pt.getSecond(), buffer);
        });
        buffer.m_130130_(this.pointsRemoved.size());
        this.pointsRemoved.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130077_(arg_0));
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (context.getSender() != null) {
                PointsOfInterest.handleUpdateFromGui(context.getSender(), this);
            }
        });
        return true;
    }
}

