/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.network;

import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.waypoints.BasicWaypoint;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class AddWaypoint {
    public final String label;
    public final double x;
    public final double y;
    public final double z;
    public final boolean isMarker;
    public final int iconIndex;

    public AddWaypoint(String label, double x, double y, double z, boolean isMarker, int iconIndex) {
        this.label = label;
        this.x = x;
        this.y = y;
        this.z = z;
        this.isMarker = isMarker;
        this.iconIndex = iconIndex;
    }

    public AddWaypoint(BasicWaypoint point) {
        Vec3 position = point.getPosition();
        this.label = point.getLabelText();
        this.x = position.f_82479_;
        this.y = position.f_82480_;
        this.z = position.f_82481_;
        BasicIconData data = (BasicIconData)point.getIconData();
        this.isMarker = data.getSerializer() == HudCompass.MAP_MARKER_SERIALIZER.get();
        this.iconIndex = data.iconIndex;
    }

    public AddWaypoint(FriendlyByteBuf buffer) {
        this.label = buffer.m_130136_(256);
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.isMarker = buffer.readBoolean();
        this.iconIndex = buffer.m_130242_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.label);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeBoolean(this.isMarker);
        buffer.m_130130_(this.iconIndex);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> PointsOfInterest.handleAddWaypoint(context.getSender(), this));
        return true;
    }
}

