/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.integrations.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.gigaherz.hudcompass.ConfigData;
import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import dev.gigaherz.hudcompass.waypoints.SpecificPointInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapBanner;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class VanillaMapPoints {
    public static final VanillaMapPoints INSTANCE = new VanillaMapPoints();
    private static final ResourceLocation ADDON_ID = HudCompass.location("vanilla_map");
    private static final DeferredRegister<PointInfoType<?>> PIT = HudCompass.POINT_INFO_TYPES;
    public static final RegistryObject<PointInfoType<MapDecorationWaypoint>> DECORATION_TYPE = PIT.register("map_decoration", () -> new PointInfoType<MapDecorationWaypoint>(MapDecorationWaypoint::new));
    public static final RegistryObject<PointInfoType<MapBannerWaypoint>> BANNER_TYPE = PIT.register("map_banner", () -> new PointInfoType<MapBannerWaypoint>(MapBannerWaypoint::new));
    private int counter = 0;

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(INSTANCE::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::playerTick);
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++this.counter > 20) {
            this.counter = 0;
            Player player = event.player;
            if (player.m_9236_().f_46443_) {
                return;
            }
            player.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
                PointsOfInterest.WorldPoints worldPoints = pois.get(player.m_9236_());
                VanillaMapData addon = pois.getOrCreateAddonData(ADDON_ID, () -> new VanillaMapData());
                Set<MapItemSavedData> seenMaps = this.getMapData(player, worldPoints, addon);
                HashSet<MapItemSavedData> toRemove = new HashSet<MapItemSavedData>(addon.mapDecorations.keySet());
                toRemove.removeAll(seenMaps);
                for (MapItemSavedData remove : toRemove) {
                    Map<MapDecoration, PointInfo<?>> map = addon.mapDecorations.get(remove);
                    for (PointInfo<?> pt : map.values()) {
                        worldPoints.removePoint(pt);
                    }
                    addon.mapDecorations.remove(remove);
                }
            });
        }
    }

    @Nonnull
    private Set<MapItemSavedData> getMapData(Player player, PointsOfInterest.WorldPoints worldPoints, VanillaMapData addon) {
        if (!((Boolean)ConfigData.COMMON.enableVanillaMapIntegration.get()).booleanValue()) {
            return Collections.emptySet();
        }
        HashSet seenMaps = Sets.newHashSet();
        for (int slot = 0; slot < player.m_150109_().m_6643_(); ++slot) {
            ItemStack stack = player.m_150109_().m_8020_(slot);
            MapItemSavedData mapData = MapItem.m_42853_((ItemStack)stack, (Level)player.m_9236_());
            if (mapData == null || seenMaps.contains(mapData) || mapData.f_77887_ != worldPoints.getWorldKey()) continue;
            seenMaps.add(mapData);
            Map decorationPointInfoMap = addon.mapDecorations.computeIfAbsent(mapData, k -> Maps.newHashMap());
            for (MapBanner mapBanner : mapData.f_77897_.values()) {
                MapDecoration decoration = (MapDecoration)mapData.f_77894_.get(mapBanner.m_77787_());
                if (decorationPointInfoMap.containsKey(decoration)) continue;
                MapBannerWaypoint wp = new MapBannerWaypoint(mapBanner, decoration);
                decorationPointInfoMap.put(decoration, wp);
                worldPoints.addPoint(wp);
            }
            for (Map.Entry entry : mapData.f_77894_.entrySet()) {
                String decorationId = (String)entry.getKey();
                MapDecoration decoration = (MapDecoration)entry.getValue();
                if (decoration.m_77803_() == MapDecoration.Type.PLAYER || decoration.m_77803_() == MapDecoration.Type.PLAYER_OFF_LIMITS || decoration.m_77803_() == MapDecoration.Type.PLAYER_OFF_MAP || decorationPointInfoMap.containsKey(decoration)) continue;
                MapDecorationWaypoint wp = new MapDecorationWaypoint(mapData, decoration);
                decorationPointInfoMap.put(decoration, wp);
                worldPoints.addPoint(wp);
            }
            HashSet toRemove = new HashSet(decorationPointInfoMap.keySet());
            toRemove.removeAll(mapData.f_77894_.values());
            for (MapDecoration remove : toRemove) {
                worldPoints.removePoint((PointInfo)decorationPointInfoMap.get(remove));
                decorationPointInfoMap.remove(remove);
            }
        }
        return seenMaps;
    }

    private class VanillaMapData {
        public Map<MapItemSavedData, Map<MapDecoration, PointInfo<?>>> mapDecorations = Maps.newHashMap();

        private VanillaMapData() {
        }
    }

    public static class MapBannerWaypoint
    extends SpecificPointInfo<MapBannerWaypoint, BasicIconData> {
        private final MapBanner banner;
        private Vec3 position;

        public MapBannerWaypoint(MapBanner banner, MapDecoration decoration) {
            super((PointInfoType)BANNER_TYPE.get(), true, banner.m_77783_(), BasicIconData.mapMarker(decoration.m_77803_().m_77853_()));
            this.dynamic();
            this.banner = banner;
            this.position = Vec3.m_82512_((Vec3i)banner.m_77773_());
        }

        public MapBannerWaypoint() {
            super((PointInfoType)BANNER_TYPE.get(), true);
            this.banner = null;
        }

        @Nullable
        public MapBanner getBanner() {
            return this.banner;
        }

        @Override
        public Vec3 getPosition() {
            return this.position;
        }

        @Override
        public Vec3 getPosition(Player player, float partialTicks) {
            return this.position;
        }

        @Override
        protected void serializeAdditional(CompoundTag tag) {
            tag.m_128347_("X", this.position.f_82479_);
            tag.m_128347_("Y", this.position.f_82480_);
            tag.m_128347_("Z", this.position.f_82481_);
        }

        @Override
        protected void deserializeAdditional(CompoundTag tag) {
            this.position = new Vec3(tag.m_128459_("X"), tag.m_128459_("Y"), tag.m_128459_("Z"));
        }

        @Override
        protected void serializeAdditional(FriendlyByteBuf buffer) {
            buffer.writeDouble(this.position.f_82479_);
            buffer.writeDouble(this.position.f_82480_);
            buffer.writeDouble(this.position.f_82481_);
        }

        @Override
        protected void deserializeAdditional(FriendlyByteBuf buffer) {
            this.position = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    }

    public static class MapDecorationWaypoint
    extends SpecificPointInfo<MapDecorationWaypoint, BasicIconData> {
        private final MapDecoration decoration;
        private Vec3 position;

        public MapDecorationWaypoint(MapItemSavedData mapData, MapDecoration decoration) {
            super((PointInfoType)DECORATION_TYPE.get(), true, (Component)null, BasicIconData.mapMarker(decoration.m_77803_().m_77853_()));
            this.dynamic();
            this.noVerticalDistance();
            float decoX = ((float)decoration.m_77804_() - 0.5f) * 0.5f;
            float decoZ = ((float)decoration.m_77805_() - 0.5f) * 0.5f;
            int scale = 1 << mapData.f_77890_;
            float worldX = (float)mapData.f_256718_ + decoX * (float)scale;
            float worldZ = (float)mapData.f_256789_ + decoZ * (float)scale;
            this.decoration = decoration;
            this.position = new Vec3((double)worldX, 0.0, (double)worldZ);
        }

        public MapDecorationWaypoint() {
            super((PointInfoType)DECORATION_TYPE.get(), true);
            this.decoration = null;
        }

        @Nullable
        public MapDecoration getDecoration() {
            return this.decoration;
        }

        @Override
        public Vec3 getPosition() {
            return this.position;
        }

        @Override
        public Vec3 getPosition(Player player, float partialTicks) {
            return this.position;
        }

        @Override
        protected void serializeAdditional(CompoundTag tag) {
            tag.m_128347_("X", this.position.f_82479_);
            tag.m_128347_("Y", this.position.f_82480_);
            tag.m_128347_("Z", this.position.f_82481_);
        }

        @Override
        protected void deserializeAdditional(CompoundTag tag) {
            this.position = new Vec3(tag.m_128459_("X"), tag.m_128459_("Y"), tag.m_128459_("Z"));
        }

        @Override
        protected void serializeAdditional(FriendlyByteBuf buffer) {
            buffer.writeDouble(this.position.f_82479_);
            buffer.writeDouble(this.position.f_82480_);
            buffer.writeDouble(this.position.f_82481_);
        }

        @Override
        protected void deserializeAdditional(FriendlyByteBuf buffer) {
            this.position = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    }
}

