/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.integrations.server;

import dev.gigaherz.hudcompass.ConfigData;
import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.waypoints.BasicWaypoint;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public class SpawnPointPoints {
    public static final SpawnPointPoints INSTANCE = new SpawnPointPoints();
    private static final ResourceLocation ADDON_ID = HudCompass.location("spawn_point");
    private int counter = 0;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::playerTick);
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++this.counter > 20) {
            this.counter = 0;
            Player player = event.player;
            if (player.m_9236_().f_46443_) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
                boolean hasBed;
                SpawnPointAddon addon = pois.getOrCreateAddonData(ADDON_ID, SpawnPointAddon::new);
                ResourceKey worldKey = serverPlayer.m_8963_();
                BlockPos spawnPosition = serverPlayer.m_8961_();
                boolean enabled = (Boolean)ConfigData.COMMON.enableSpawnPointWaypoint.get();
                boolean hasWaypoint = addon.waypoint != null;
                boolean dimensionChanged = addon.spawnWorld != worldKey;
                boolean positionChanged = !Objects.equals(addon.spawnPosition, spawnPosition);
                boolean waypointChanged = dimensionChanged || positionChanged;
                boolean bl = hasBed = spawnPosition != null;
                if (hasWaypoint && (!enabled || !hasBed || waypointChanged)) {
                    pois.get(addon.spawnWorld).removePoint(addon.waypoint);
                    addon.waypoint = null;
                    addon.spawnWorld = null;
                    addon.spawnPosition = null;
                }
                if (enabled && hasBed && (!hasWaypoint || waypointChanged)) {
                    addon.spawnWorld = worldKey;
                    addon.spawnPosition = spawnPosition;
                    addon.waypoint = (BasicWaypoint)new BasicWaypoint((PointInfoType)HudCompass.BASIC_WAYPOINT.get(), Vec3.m_82512_((Vec3i)spawnPosition), "Home", BasicIconData.mapMarker(8)).dynamic();
                    pois.get(addon.spawnWorld).addPoint(addon.waypoint);
                }
            });
        }
    }

    private static class SpawnPointAddon {
        @Nullable
        public BasicWaypoint waypoint;
        public ResourceKey<Level> spawnWorld;
        public BlockPos spawnPosition;

        private SpawnPointAddon() {
        }
    }
}

