/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.integrations.server;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.gigaherz.hudcompass.ConfigData;
import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.icons.IIconData;
import dev.gigaherz.hudcompass.icons.IconDataSerializer;
import dev.gigaherz.hudcompass.icons.client.IIconRenderer;
import dev.gigaherz.hudcompass.icons.client.IconRendererRegistry;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import dev.gigaherz.hudcompass.waypoints.SpecificPointInfo;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.joml.Matrix4f;

public class PlayerTracker {
    public static final PlayerTracker INSTANCE = new PlayerTracker();
    private static final ResourceLocation ADDON_ID = HudCompass.location("player_tracker");
    private static final DeferredRegister<PointInfoType<?>> PIT = HudCompass.POINT_INFO_TYPES;
    private static final DeferredRegister<IconDataSerializer<?>> IDS = HudCompass.ICON_DATA_SERIALIZERS;
    public static final RegistryObject<PointInfoType<PlayerWaypoint>> PLAYER_POINT = PIT.register("player", () -> new PointInfoType<PlayerWaypoint>(PlayerWaypoint::new));
    public static final RegistryObject<PlayerIconData.Serializer> ICON_DATA = IDS.register("player", PlayerIconData.Serializer::new);
    private int counter = 0;

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(INSTANCE::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::playerTick);
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::startTracking);
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::stopTracking);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        IconRendererRegistry.registerRenderer((IconDataSerializer)ICON_DATA.get(), new OtherPlayerRenderer());
    }

    private void startTracking(PlayerEvent.StartTracking event) {
        ServerPlayer target;
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof ServerPlayer && !((target = (ServerPlayer)entity) instanceof FakePlayer)) {
            player.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
                PointsOfInterest.WorldPoints worldPoints = pois.get(player.m_9236_());
                PlayerDataAddon addon = pois.getOrCreateAddonData(ADDON_ID, PlayerDataAddon::new);
                PlayerWaypoint wp = new PlayerWaypoint((Player)target);
                UUID uuid = target.m_20148_();
                addon.players.put(uuid, wp);
                addon.teams.put(uuid, target.m_5647_());
                addon.playerTeam = player.m_5647_();
                if (ConfigData.playerDisplay == ConfigData.PlayerDisplay.ALL || ConfigData.playerDisplay == ConfigData.PlayerDisplay.TEAM && target.m_5647_() == player.m_5647_()) {
                    worldPoints.addPoint(wp);
                }
            });
        }
    }

    private void stopTracking(PlayerEvent.StopTracking event) {
        ServerPlayer target;
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof ServerPlayer && !((target = (ServerPlayer)entity) instanceof FakePlayer)) {
            player.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
                PointsOfInterest.WorldPoints worldPoints = pois.get(player.m_9236_());
                PlayerDataAddon addon = pois.getOrCreateAddonData(ADDON_ID, PlayerDataAddon::new);
                UUID uuid = target.m_20148_();
                PlayerWaypoint wp = addon.players.get(uuid);
                if (wp != null) {
                    worldPoints.removePoint(wp);
                }
                addon.players.remove(uuid);
                addon.teams.remove(uuid);
            });
        }
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (ConfigData.playerDisplay != ConfigData.PlayerDisplay.TEAM) {
            return;
        }
        if (++this.counter > 20) {
            this.counter = 0;
            Player player = event.player;
            if (player.m_9236_().f_46443_) {
                return;
            }
            player.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
                PointsOfInterest.WorldPoints worldPoints = pois.get(player.m_9236_());
                PlayerDataAddon addon = pois.getOrCreateAddonData(ADDON_ID, PlayerDataAddon::new);
                boolean changedTeam = addon.playerTeam != player.m_5647_();
                addon.playerTeam = player.m_5647_();
                for (PlayerWaypoint wp : addon.players.values()) {
                    Player target = player.m_9236_().m_46003_(wp.playerUUID);
                    if (target == null) continue;
                    Team currentTeam = target.m_5647_();
                    if (!changedTeam && addon.teams.get(wp.playerUUID) == currentTeam) continue;
                    addon.teams.put(wp.playerUUID, currentTeam);
                    worldPoints.removePoint(wp);
                    if (currentTeam != player.m_5647_()) continue;
                    worldPoints.addPoint(wp);
                }
            });
        }
    }

    private static class OtherPlayerRenderer
    implements IIconRenderer<PlayerIconData> {
        private OtherPlayerRenderer() {
        }

        @Override
        public void renderIcon(PlayerIconData data, Player player, TextureManager textureManager, GuiGraphics graphics, int x, int y, int alpha) {
            Player player2 = player.m_9236_().m_46003_(data.playerId);
            if (player2 instanceof AbstractClientPlayer) {
                AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player2;
                ResourceLocation tex = clientPlayer.m_108560_();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha / 255.0f));
                OtherPlayerRenderer.drawFaceLayer(graphics, x - 4, y - 4, 8.0f, 8.0f, 8);
                OtherPlayerRenderer.drawFaceLayer(graphics, (float)x - 4.5f, (float)y - 4.5f, 9.0f, 9.0f, 40);
            }
        }

        private static void drawFaceLayer(GuiGraphics graphics, float x1, float y1, float w, float h, int tx) {
            Matrix4f pMatrix = graphics.m_280168_().m_85850_().m_252922_();
            float x2 = x1 + w;
            float y2 = y1 + h;
            float u1 = (float)tx / 64.0f;
            float u2 = (float)(tx + 8) / 64.0f;
            RenderSystem.setShader(GameRenderer::m_172817_);
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_252986_(pMatrix, x1, y2, 0.0f).m_7421_(u1, 0.25f).m_5752_();
            bufferbuilder.m_252986_(pMatrix, x2, y2, 0.0f).m_7421_(u2, 0.25f).m_5752_();
            bufferbuilder.m_252986_(pMatrix, x2, y1, 0.0f).m_7421_(u2, 0.125f).m_5752_();
            bufferbuilder.m_252986_(pMatrix, x1, y1, 0.0f).m_7421_(u1, 0.125f).m_5752_();
            Tesselator.m_85913_().m_85914_();
        }
    }

    private static class PlayerDataAddon {
        public Map<UUID, PlayerWaypoint> players = Maps.newHashMap();
        public Map<UUID, Team> teams = Maps.newHashMap();
        @Nullable
        public Team playerTeam;

        private PlayerDataAddon() {
        }
    }

    public static class PlayerWaypoint
    extends SpecificPointInfo<PlayerWaypoint, PlayerIconData> {
        private UUID playerUUID;
        private Vec3 position;

        public PlayerWaypoint(@Nonnull Player player) {
            super((PointInfoType)PLAYER_POINT.get(), true, player.m_5446_(), new PlayerIconData(player.m_20148_()));
            this.dynamic();
            this.playerUUID = player.m_20148_();
            this.position = player.m_20182_();
        }

        public PlayerWaypoint() {
            super((PointInfoType)PLAYER_POINT.get(), true, (Component)null, new PlayerIconData());
            this.dynamic();
            this.playerUUID = Util.f_137441_;
            this.position = Vec3.f_82478_;
        }

        @Override
        public Vec3 getPosition() {
            return this.position;
        }

        @Override
        public Vec3 getPosition(Player player, float partialTicks) {
            Player target = player.m_9236_().m_46003_(this.playerUUID);
            if (target == null) {
                return this.position;
            }
            return target.m_20318_(partialTicks);
        }

        @Override
        protected void serializeAdditional(CompoundTag tag) {
            tag.m_128362_("Player", this.playerUUID);
        }

        @Override
        protected void deserializeAdditional(CompoundTag tag) {
            this.playerUUID = tag.m_128342_("Player");
            ((PlayerIconData)this.getIconData()).setPlayer(this.playerUUID);
        }

        @Override
        protected void serializeAdditional(FriendlyByteBuf buffer) {
            buffer.m_130077_(this.playerUUID);
        }

        @Override
        protected void deserializeAdditional(FriendlyByteBuf buffer) {
            this.playerUUID = buffer.m_130259_();
            ((PlayerIconData)this.getIconData()).setPlayer(this.playerUUID);
        }

        @Override
        public void tick(Player player) {
            if (!player.m_9236_().f_46443_) {
                return;
            }
            Player target = player.m_9236_().m_46003_(this.playerUUID);
            if (target == null) {
                return;
            }
            Vec3 newPos = target.m_20182_();
            Component newLabel = target.m_5446_();
            this.position = newPos;
            this.setLabel(newLabel);
        }
    }

    private static class PlayerIconData
    implements IIconData<PlayerIconData> {
        private UUID playerId = Util.f_137441_;

        public PlayerIconData(UUID player) {
            this.playerId = player;
        }

        public PlayerIconData() {
        }

        @Override
        public IconDataSerializer<PlayerIconData> getSerializer() {
            return (IconDataSerializer)ICON_DATA.get();
        }

        public void setPlayer(UUID playerId) {
            this.playerId = playerId;
        }

        private static class Serializer
        extends IconDataSerializer<PlayerIconData> {
            private Serializer() {
            }

            @Override
            public CompoundTag write(PlayerIconData data, CompoundTag tag) {
                tag.m_128362_("Player", data.playerId);
                return tag;
            }

            @Override
            public PlayerIconData read(CompoundTag tag) {
                return new PlayerIconData(tag.m_128342_("Player"));
            }

            @Override
            public PlayerIconData read(FriendlyByteBuf buffer) {
                return new PlayerIconData(buffer.m_130259_());
            }

            @Override
            public void write(PlayerIconData data, FriendlyByteBuf buffer) {
                buffer.m_130077_(data.playerId);
            }
        }
    }
}

