/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.integrations.journeymap;

import dev.gigaherz.hudcompass.ConfigData;
import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import dev.gigaherz.hudcompass.waypoints.SpecificPointInfo;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.event.WaypointEvent;
import journeymap.client.api.model.MapImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@ClientPlugin
public class JourneymapIntegration
implements IClientPlugin {
    private static final DeferredRegister<PointInfoType<?>> PIT = HudCompass.POINT_INFO_TYPES;
    public static final RegistryObject<PointInfoType<JmWaypoint>> JM_WAYPOINT = PIT.register("journeymap", () -> new PointInfoType<JmWaypoint>(JmWaypoint::new));

    public static void staticInit() {
    }

    public void initialize(IClientAPI jmClientApi) {
        jmClientApi.subscribe(this.getModId(), EnumSet.of(ClientEvent.Type.WAYPOINT));
    }

    public String getModId() {
        return "hudcompass";
    }

    public void onEvent(ClientEvent event) {
        if (!(event instanceof WaypointEvent)) {
            return;
        }
        WaypointEvent wpEvent = (WaypointEvent)event;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!ConfigData.enableJourneymapIntegration) {
            return;
        }
        player.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
            PointsOfInterest.WorldPoints worldPoints = pois.get(player.m_9236_());
            String dimensionName = player.m_9236_().m_46472_().m_135782_().toString();
            Waypoint jmwp = wpEvent.waypoint;
            UUID id = JourneymapIntegration.getId(jmwp);
            boolean isVisible = jmwp.isEnabled() && (jmwp.getDisplayDimensions() == null || Arrays.asList(jmwp.getDisplayDimensions()).contains(dimensionName));
            switch (wpEvent.getContext()) {
                case DELETED: {
                    worldPoints.removePoint(id);
                    break;
                }
                case READ: 
                case CREATE: {
                    if (!isVisible) break;
                    worldPoints.addPoint(new JmWaypoint(jmwp));
                    break;
                }
                default: {
                    if (isVisible) {
                        worldPoints.addPoint(new JmWaypoint(jmwp));
                        break;
                    }
                    worldPoints.removePoint(id);
                }
            }
        });
    }

    @Nonnull
    private static UUID getId(Waypoint jmwp) {
        byte[] bytes = jmwp.getGuid().getBytes(StandardCharsets.UTF_8);
        return UUID.nameUUIDFromBytes(bytes);
    }

    public static class JmWaypoint
    extends SpecificPointInfo<JmWaypoint, BasicIconData> {
        private final Waypoint jmWaypoint;

        public JmWaypoint(Waypoint jmWaypoint) {
            super((PointInfoType)JM_WAYPOINT.get(), true, (Component)Component.m_237113_((String)jmWaypoint.getName()), BasicIconData.poi(5));
            this.jmWaypoint = jmWaypoint;
            this.dynamic();
            this.clientPoint();
            UUID id = JourneymapIntegration.getId(jmWaypoint);
            this.setInternalId(id);
            if (jmWaypoint.hasIcon()) {
                BasicIconData basicIconData = (BasicIconData)this.getIconData();
                MapImage icon = jmWaypoint.getIcon();
                int rgb = icon.getColor();
                float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                float b = (float)(rgb & 0xFF) / 255.0f;
                float a = 1.0f;
                basicIconData.setColor(r, g, b, a);
            }
        }

        public JmWaypoint() {
            super((PointInfoType)JM_WAYPOINT.get(), true, (Component)null, BasicIconData.poi(5));
            throw new IllegalStateException("This waypoint is client-only and cannot be synchronized.");
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.m_82512_((Vec3i)this.jmWaypoint.getPosition());
        }

        @Override
        public Vec3 getPosition(Player player, float partialTicks) {
            return this.getPosition();
        }

        @Override
        protected void serializeAdditional(CompoundTag tag) {
            throw new IllegalStateException("This waypoint is dynamic and cannot be serialized.");
        }

        @Override
        protected void deserializeAdditional(CompoundTag tag) {
            throw new IllegalStateException("This waypoint is dynamic and cannot be serialized.");
        }

        @Override
        protected void serializeAdditional(FriendlyByteBuf tag) {
            throw new IllegalStateException("This waypoint is client-only and cannot be synchronized.");
        }

        @Override
        protected void deserializeAdditional(FriendlyByteBuf tag) {
            throw new IllegalStateException("This waypoint is client-only and cannot be synchronized.");
        }
    }
}

