/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.icons.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.icons.client.IIconRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class BasicIconRenderer
implements IIconRenderer<BasicIconData> {
    public final int texW;
    public final int texH;
    public final int iconW;
    public final int iconH;
    public final int iconsPerRow;
    public final int iconsPerCol;
    private final ResourceLocation texture;

    public BasicIconRenderer(ResourceLocation texture) {
        this(texture, 128, 128, 8, 8);
    }

    public BasicIconRenderer(ResourceLocation texture, int texW, int texH, int iconW, int iconH) {
        this.texture = texture;
        this.texW = texW;
        this.texH = texH;
        this.iconW = iconW;
        this.iconH = iconH;
        this.iconsPerRow = texW / iconW;
        this.iconsPerCol = texH / iconH;
    }

    @Override
    public void renderIcon(BasicIconData data, Player player, TextureManager textureManager, GuiGraphics graphics, int x, int y, int alpha) {
        RenderSystem.setShaderColor((float)data.r, (float)data.g, (float)data.b, (float)(data.a * ((float)alpha / 255.0f)));
        int indexX = data.iconIndex % this.iconsPerRow;
        int indexY = data.iconIndex / this.iconsPerCol;
        graphics.m_280163_(this.texture, x - this.iconW / 2, y - this.iconH / 2, (float)(indexX * this.iconW), (float)(indexY * this.iconH), this.iconW, this.iconH, this.texW, this.texH);
    }
}

