/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.gigaherz.hudcompass.ConfigData;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import dev.gigaherz.hudcompass.waypoints.client.PointRenderer;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="hudcompass", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HudOverlay
implements IGuiOverlay {
    public static final ResourceLocation LOCATION_MAP_ICONS = new ResourceLocation("minecraft", "textures/map/map_icons.png");
    public static final ResourceLocation LOCATION_POI_ICONS = new ResourceLocation("hudcompass", "textures/poi_icons.png");
    private final Minecraft mc = Minecraft.m_91087_();
    private final Font font;
    private final TextureManager textureManager;
    boolean needsPop = false;
    private static final TagKey<Item> MAKES_HUDCOMPASS_VISIBLE = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("hudcompass:makes_hudcompass_visible"));

    @SubscribeEvent
    public static void init(FMLConstructModEvent event) {
    }

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.BOSS_EVENT_PROGRESS.id(), "compass", (IGuiOverlay)new HudOverlay());
    }

    private HudOverlay() {
        this.font = this.mc.f_91062_;
        this.textureManager = this.mc.f_90987_;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void preOverlayHigh(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == VanillaGuiOverlay.BOSS_EVENT_PROGRESS.type() && !this.mc.f_91066_.f_92062_ && this.canRender()) {
            PoseStack matrixStack = event.getGuiGraphics().m_280168_();
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, 28.0f, 0.0f);
            this.needsPop = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void postOverlay(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.BOSS_EVENT_PROGRESS.type() && this.needsPop) {
            PoseStack matrixStack = event.getGuiGraphics().m_280168_();
            matrixStack.m_85849_();
            this.needsPop = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void preRender(RenderGuiEvent.Pre event) {
        this.needsPop = false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void postRender(RenderGuiEvent.Post event) {
        if (this.needsPop) {
            PoseStack matrixStack = event.getGuiGraphics().m_280168_();
            matrixStack.m_85849_();
            this.needsPop = false;
        }
    }

    public void render(ForgeGui gui, GuiGraphics graphics, float _partialTicks, int width, int height) {
        if (!this.canRender()) {
            return;
        }
        if (this.mc.f_91074_ == null) {
            return;
        }
        boolean isPaused = this.mc.m_91104_();
        float elapsed = isPaused ? 0.0f : this.mc.m_91297_();
        float partialTicks = isPaused ? 0.0f : _partialTicks;
        int xPos = this.mc.m_91268_().m_85445_() / 2;
        float yaw = Mth.m_14179_((float)partialTicks, (float)this.mc.f_91074_.f_20886_, (float)this.mc.f_91074_.f_20885_) % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        RenderSystem.enableBlend();
        HudOverlay.fillRect(graphics, xPos - 90, 10.0f, xPos + 90, 18.0f, 0x3F000000);
        this.drawCardinalDirection(graphics, yaw, 0.0f, xPos, "S");
        this.drawCardinalDirection(graphics, yaw, 90.0f, xPos, "W");
        this.drawCardinalDirection(graphics, yaw, 180.0f, xPos, "N");
        this.drawCardinalDirection(graphics, yaw, 270.0f, xPos, "E");
        HudOverlay.fillRect(graphics, (float)xPos - 1.5f, 10.0f, (float)xPos - 0.5f, 18.0f, 0x3FFFFFFF);
        HudOverlay.fillRect(graphics, (float)xPos + 0.5f, 10.0f, (float)xPos + 1.5f, 18.0f, 0x3FFFFFFF);
        HudOverlay.fillRect(graphics, (float)(xPos - 45) - 0.5f, 10.0f, (float)(xPos - 45) + 0.5f, 18.0f, 0x3FFFFFFF);
        HudOverlay.fillRect(graphics, (float)(xPos + 45) - 0.5f, 10.0f, (float)(xPos + 45) + 0.5f, 18.0f, 0x3FFFFFFF);
        LocalPlayer player = this.mc.f_91074_;
        double playerPosX = Mth.m_14139_((double)partialTicks, (double)this.mc.f_91074_.f_19854_, (double)this.mc.f_91074_.m_20185_());
        double playerPosY = Mth.m_14139_((double)partialTicks, (double)this.mc.f_91074_.f_19855_, (double)this.mc.f_91074_.m_20186_());
        double playerPosZ = Mth.m_14139_((double)partialTicks, (double)this.mc.f_91074_.f_19856_, (double)this.mc.f_91074_.m_20189_());
        Vec3 playerPosition = new Vec3(playerPosX, playerPosY, playerPosZ);
        float yaw0 = yaw;
        float elapsed0 = elapsed;
        player.getCapability(PointsOfInterest.INSTANCE).ifPresent(arg_0 -> this.lambda$render$1((Player)player, partialTicks, yaw0, playerPosX, playerPosY, playerPosZ, graphics, xPos, elapsed0, playerPosition, arg_0));
    }

    private boolean canRender() {
        if (this.mc.f_91074_ == null) {
            return false;
        }
        if (this.mc.f_91066_.f_92099_.m_90857_()) {
            return false;
        }
        return switch (ConfigData.displayWhen) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigData.DisplayWhen.NEVER -> false;
            case ConfigData.DisplayWhen.ALWAYS -> true;
            case ConfigData.DisplayWhen.HAS_COMPASS -> this.findCompassInInventory();
            case ConfigData.DisplayWhen.HOLDING_COMPASS -> this.findCompassInHands();
        };
    }

    private boolean findCompassInHands() {
        if (this.mc.f_91074_ == null) {
            return false;
        }
        return this.mc.f_91074_.m_21205_().m_204117_(MAKES_HUDCOMPASS_VISIBLE) || this.mc.f_91074_.m_21206_().m_204117_(MAKES_HUDCOMPASS_VISIBLE);
    }

    private boolean findCompassInInventory() {
        if (this.mc.f_91074_ == null) {
            return false;
        }
        Inventory inv = this.mc.f_91074_.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (!inv.m_8020_(i).m_204117_(MAKES_HUDCOMPASS_VISIBLE)) continue;
            return true;
        }
        return false;
    }

    private Vec2 angleFromPoint(Vec3 position, double playerPosX, double playerPosY, double playerPosZ) {
        double xd = position.f_82479_ - playerPosX;
        double yd = position.f_82480_ - playerPosY;
        double zd = position.f_82481_ - playerPosZ;
        return new Vec2((float)Math.toDegrees(-Math.atan2(xd, zd)), (float)yd);
    }

    private void drawCardinalDirection(GuiGraphics graphics, float yaw, float angle, int xPos, String text) {
        float nDist = this.angleDistance(yaw, angle);
        if (Math.abs(nDist) <= 90.0f) {
            float nPos = (float)xPos + nDist;
            HudOverlay.fillRect(graphics, nPos - 0.5f, 10.0f, nPos + 0.5f, 18.0f, Integer.MAX_VALUE);
            if (((Boolean)this.mc.f_91066_.m_231827_().m_231551_()).booleanValue()) {
                this.drawCenteredShadowString(graphics, this.font, text, nPos, 1.0f, 0xFFFFFF);
            } else {
                HudOverlay.drawCenteredBoxedString(graphics, this.font, text, nPos, 1.0f, 0xFFFFFF);
            }
        }
    }

    public void drawCenteredShadowString(GuiGraphics graphics, Font font, String text, float x, float y, int color) {
        float width = font.m_92895_(text);
        graphics.drawString(font, text, x - width / 2.0f, y, color, true);
    }

    public static void drawCenteredBoxedString(GuiGraphics graphics, Font font, String text, float x, float y, int color) {
        Minecraft mc = Minecraft.m_91087_();
        float width = font.m_92895_(text);
        Objects.requireNonNull(font);
        float height = 9.0f;
        float width1 = width + 4.0f;
        float height1 = height + 3.0f;
        float x0 = x - width1 / 2.0f;
        int backgroundColor = (int)Mth.m_14008_((double)((Double)mc.f_91066_.m_232104_().m_231551_() * (double)(color >> 24 & 0xFF)), (double)0.0, (double)255.0) << 24;
        HudOverlay.fillRect(graphics, x0, y, x0 + width1, y + height1, backgroundColor);
        graphics.drawString(font, text, x - width / 2.0f, y + 2.0f, color, false);
        RenderSystem.enableBlend();
    }

    public static void drawCenteredBoxedString(GuiGraphics graphics, Font font, Component text, float x, float y, int color) {
        FormattedCharSequence reodering = text.m_7532_();
        Minecraft mc = Minecraft.m_91087_();
        float width = font.m_92724_(reodering);
        Objects.requireNonNull(font);
        float height = 9.0f;
        float width1 = width + 4.0f;
        float height1 = height + 3.0f;
        float x0 = x - width1 / 2.0f;
        HudOverlay.fillRect(graphics, x0, y, x0 + width1, y + height1, (int)Mth.m_14008_((double)((Double)mc.f_91066_.m_232104_().m_231551_() * (double)(color >> 24 & 0xFF)), (double)0.0, (double)255.0) << 24);
        graphics.drawString(font, reodering, x - width / 2.0f, y + 2.0f, color, true);
        RenderSystem.enableBlend();
    }

    private void drawPoi(Player player, GuiGraphics graphics, float yaw, float angle, float yDelta, int xPos, PointInfo<?> point, boolean isTargetted, float elapsed, Vec3 subtract) {
        double fadeSqr = ConfigData.waypointViewDistance * ConfigData.waypointViewDistance;
        double distance2 = subtract.m_82556_();
        if (distance2 > fadeSqr) {
            return;
        }
        double distance = Math.sqrt(distance2);
        double distanceFade = 1.0 - Mth.m_14008_((double)((distance - ConfigData.waypointFadeDistance) / (ConfigData.waypointViewDistance - ConfigData.waypointFadeDistance)), (double)0.0, (double)1.0);
        int alpha = (int)(255.0 * distanceFade);
        float nDist = this.angleDistance(yaw, angle);
        if (alpha > 0 && Math.abs(nDist) <= 90.0f) {
            boolean showLabel;
            float nPos = (float)xPos + nDist;
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(nPos, 0.0f, 0.0f);
            PointRenderer.renderIcon(point, player, this.textureManager, graphics, 0, 14, alpha);
            boolean bl = showLabel = ConfigData.alwaysShowLabels || ConfigData.alwaysShowFocusedLabel && isTargetted || ConfigData.showAllLabelsOnSneak && Screen.m_96638_();
            if (ConfigData.animateLabels) {
                if (showLabel && point.fade < 255.0f) {
                    point.fade = Math.min(point.fade + 35.0f * elapsed, 255.0f);
                } else if (!showLabel && point.fade > 0.0f) {
                    point.fade = Math.max(point.fade - 35.0f * elapsed, 0.0f);
                }
            } else {
                point.fade = showLabel ? 255.0f : 0.0f;
            }
            double pointFade = distanceFade * (double)point.fade;
            if (pointFade > 4.0) {
                PointRenderer.renderLabel(point, this.font, graphics, 0, 20, (int)pointFade);
            }
            if (point.displayVerticalDistance(player)) {
                if (yDelta >= 2.0f) {
                    this.drawAboveArrow(graphics, yDelta, alpha);
                }
                if (yDelta <= -2.0f) {
                    this.drawBelowArrow(graphics, yDelta, alpha);
                }
            }
            poseStack.m_85849_();
        }
    }

    private void drawAboveArrow(GuiGraphics graphics, float yDelta, int alpha) {
        int x = yDelta > 10.0f ? 8 : 0;
        boolean y = false;
        HudOverlay.blitRect(graphics, -4.5f, 4.0f, x, (float)y, 8.0f, 8.0f, 128, 128, LOCATION_POI_ICONS, alpha);
    }

    private void drawBelowArrow(GuiGraphics graphics, float yDelta, int alpha) {
        int x = yDelta < -10.0f ? 24 : 16;
        boolean y = false;
        HudOverlay.blitRect(graphics, -4.5f, 16.0f, x, (float)y, 8.0f, 8.0f, 128, 128, LOCATION_POI_ICONS, alpha);
    }

    private static void fillRect(GuiGraphics graphics, float x0, float y0, float x1, float y1, int color) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder builder = tess.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        builder.m_252986_(matrix, x0, y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, x1, y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, x1, y0, 0.0f).m_6122_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, x0, y0, 0.0f).m_6122_(r, g, b, a).m_5752_();
        tess.m_85914_();
    }

    private static void blitRect(GuiGraphics graphics, float x0, float y0, float xt, float yt, float width, float height, int tWidth, int tHeight, ResourceLocation texture, int alpha) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha / 255.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        float tx0 = xt / (float)tWidth;
        float ty0 = yt / (float)tHeight;
        float tx1 = tx0 + width / (float)tWidth;
        float ty1 = ty0 + height / (float)tHeight;
        float x1 = x0 + width;
        float y1 = y0 + height;
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder builder = tess.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        builder.m_252986_(matrix, x0, y1, 0.0f).m_7421_(tx0, ty1).m_5752_();
        builder.m_252986_(matrix, x1, y1, 0.0f).m_7421_(tx1, ty1).m_5752_();
        builder.m_252986_(matrix, x1, y0, 0.0f).m_7421_(tx1, ty0).m_5752_();
        builder.m_252986_(matrix, x0, y0, 0.0f).m_7421_(tx0, ty0).m_5752_();
        tess.m_85914_();
    }

    private float angleDistance(float yaw, float other) {
        float dist = other - yaw;
        if (dist > 0.0f) {
            return dist > 180.0f ? dist - 360.0f : dist;
        }
        return dist < -180.0f ? dist + 360.0f : dist;
    }

    private /* synthetic */ void lambda$render$1(Player player, float partialTicks, float yaw0, double playerPosX, double playerPosY, double playerPosZ, GuiGraphics graphics, int xPos, float elapsed0, Vec3 playerPosition, PointsOfInterest pts) {
        ArrayList sortedPoints = Lists.newArrayList(pts.get(player.m_9236_()).getPoints());
        sortedPoints.sort((a, b) -> {
            Vec3 positionA = a.getPosition(player, partialTicks);
            Vec3 positionB = b.getPosition(player, partialTicks);
            float angleA = Math.abs(this.angleDistance(yaw0, this.angleFromPoint((Vec3)positionA, (double)playerPosX, (double)playerPosY, (double)playerPosZ).f_82470_));
            float angleB = Math.abs(this.angleDistance(yaw0, this.angleFromPoint((Vec3)positionB, (double)playerPosX, (double)playerPosY, (double)playerPosZ).f_82470_));
            return (int)Math.signum(angleB - angleA);
        });
        for (PointInfo point : sortedPoints) {
            Vec3 position = point.getPosition(player, partialTicks);
            Vec2 angleYd = this.angleFromPoint(position, playerPosX, playerPosY, playerPosZ);
            this.drawPoi(player, graphics, yaw0, angleYd.f_82470_, angleYd.f_82471_, xPos, point, point == pts.getTargetted(), elapsed0, position.m_82546_(playerPosition));
        }
    }
}

