/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.waypoints.BasicWaypoint;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.widget.ScrollPanel;

public class ClientWaypointManagerScreen
extends Screen {
    private static final Component TITLE = Component.m_237115_((String)"text.hudcompass.waypoint_editor.title");
    private static final Pattern COORD_VALIDATOR = Pattern.compile("^-?[0-9]*\\.?[0-9]*$");
    private static final Pattern COORD_FORMAT = Pattern.compile("^-?[0-9]+\\.?[0-9]+$");
    private static final Predicate<String> COORD_FORMAT_MATCHER = COORD_FORMAT.asPredicate();
    private static final int MARGIN_LEFT = 8;
    private static final int MARGIN_TOP = 32;
    private static final int MARGIN_RIGHT = 8;
    private static final int MARGIN_BOTTOM = 34;
    private final List<WaypointListItem> toAdd = new ArrayList<WaypointListItem>();
    private final List<WaypointListItem> toUpdate = new ArrayList<WaypointListItem>();
    private final List<WaypointListItem> toRemove = new ArrayList<WaypointListItem>();
    private final PointsOfInterest pois;
    private ItemsScrollPanel scrollPanel;
    private Button saveButton;

    protected ClientWaypointManagerScreen(PointsOfInterest pois) {
        super(TITLE);
        this.pois = pois;
        pois.addListener(this::onSyncReceived);
    }

    public void m_7861_() {
        super.m_7861_();
        this.pois.removeListener(this::onSyncReceived);
    }

    private void setDirty() {
        this.saveButton.f_93623_ = true;
    }

    private void onSyncReceived() {
        this.scrollPanel.clear();
        this.loadWaypoints();
        this.scrollPanel.scrollTop();
    }

    private void loadWaypoints() {
        this.pois.getAllWorlds().stream().sorted(Comparator.comparing(w -> w.getWorldKey().m_135782_())).forEach(world -> {
            WorldListItem worldItem = this.addWorld(world.getWorldKey(), world.getDimensionTypeKey());
            for (PointInfo<?> point : world.getPoints()) {
                if (point.isDynamic() || !(point instanceof BasicWaypoint)) continue;
                BasicWaypoint wp = (BasicWaypoint)point;
                this.addPoint(worldItem, wp);
            }
            this.addNewWaypointItem(worldItem);
        });
    }

    protected void m_7856_() {
        super.m_7856_();
        this.scrollPanel = (ItemsScrollPanel)this.m_142416_((GuiEventListener)new ItemsScrollPanel(this.f_96541_, this.f_96543_ - 8 - 8, this.f_96544_ - 32 - 34, 32, 8));
        this.saveButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.save"), button -> {
            this.scrollPanel.saveAll();
            this.pois.updateFromGui((ImmutableList)this.toAdd.stream().map(i -> Pair.of((Object)i.worldItem.worldKey.m_135782_(), (Object)i.pointInfo)).collect(ImmutableList.toImmutableList()), (ImmutableList)this.toUpdate.stream().map(i -> Pair.of((Object)i.worldItem.worldKey.m_135782_(), (Object)i.pointInfo)).collect(ImmutableList.toImmutableList()), (ImmutableList<UUID>)((ImmutableList)this.toRemove.stream().map(i -> i.pointInfo.getInternalId()).collect(ImmutableList.toImmutableList())));
            this.m_7379_();
        }).m_252794_(8, this.f_96544_ - 28).m_253046_(120, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.cancel"), button -> this.m_7379_()).m_252794_(this.f_96543_ - 128, this.f_96544_ - 28).m_253046_(120, 20).m_253136_());
        this.loadWaypoints();
        this.scrollPanel.scrollTop();
        this.saveButton.f_93623_ = false;
    }

    private void createNewPoint(WorldListItem worldItem) {
        BasicWaypoint wp = new BasicWaypoint(this.getPlayerPositionScaled(worldItem), "", BasicIconData.mapMarker(7));
        WaypointListItem item = new WaypointListItem(this.f_96541_, wp, worldItem);
        int index = worldItem.waypoints.size() - 1;
        WorldListItem after = index >= 0 ? (ListItem)worldItem.waypoints.get(index) : worldItem;
        this.scrollPanel.insertAfter(item, after);
        worldItem.addWaypoint(item);
        this.toAdd.add(item);
        this.scrollPanel.scrollToItem(item);
        this.setDirty();
    }

    private Vec3 getPlayerPositionScaled(WorldListItem world) {
        LocalPlayer player = this.f_96541_.f_91074_;
        Vec3 pos = player.m_20182_();
        if (player.m_9236_().m_46472_() == world.worldKey) {
            return pos;
        }
        if (world.dimensionTypeKey != null) {
            RegistryAccess dyn = player.f_108617_.m_105152_();
            DimensionType type = (DimensionType)dyn.m_175515_(Registries.f_256787_).m_123013_(world.dimensionTypeKey);
            double scale = DimensionType.m_63908_((DimensionType)player.m_9236_().m_6042_(), (DimensionType)type);
            return new Vec3(pos.f_82479_ * scale, pos.f_82480_, pos.f_82481_ * scale);
        }
        if (player.m_9236_().m_46472_() == Level.f_46429_ && world.worldKey != Level.f_46429_) {
            return new Vec3(pos.f_82479_ * 8.0, pos.f_82480_, pos.f_82481_ * 8.0);
        }
        if (player.m_9236_().m_46472_() != Level.f_46429_ && world.worldKey == Level.f_46429_) {
            return new Vec3(pos.f_82479_ / 8.0, pos.f_82480_, pos.f_82481_ / 8.0);
        }
        return pos;
    }

    private WorldListItem addWorld(ResourceKey<Level> worldKey, ResourceKey<DimensionType> dimensionTypeKey) {
        WorldListItem item = new WorldListItem(this.f_96541_, worldKey, dimensionTypeKey);
        this.scrollPanel.addItem(item);
        return item;
    }

    private void addNewWaypointItem(WorldListItem item) {
        NewWaypointListItem newWaypoint = new NewWaypointListItem(this.f_96541_, item);
        item.setNewWaypoint(newWaypoint);
        this.scrollPanel.addItem(newWaypoint);
    }

    private void addPoint(WorldListItem worldItem, BasicWaypoint wp) {
        WaypointListItem item = new WaypointListItem(this.f_96541_, wp, worldItem);
        worldItem.addWaypoint(item);
        this.scrollPanel.addItem(item);
    }

    private void deletePoint(WaypointListItem item) {
        if (!this.toAdd.remove(item)) {
            this.toRemove.add(item);
        }
        this.scrollPanel.removeItem(item);
        item.worldItem.removeWaypoint(item);
        this.setDirty();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        this.scrollPanel.setPartialTicks(partialTicks);
        this.scrollPanel.m_88315_(graphics, mouseX, mouseY, partialTicks);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280653_(this.f_96541_.f_91062_, this.f_96539_, this.f_96543_ / 2, 7, -1);
        int nameWidth = Math.max(this.scrollPanel.getContentWidth() - 212, 50);
        int x = this.scrollPanel.getLeft() + 6;
        int y = this.scrollPanel.getTop() - 10;
        graphics.m_280614_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.header_label"), x, y, -1, false);
        graphics.m_280614_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.header_x"), x += nameWidth + 3, y, -1, false);
        graphics.m_280614_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.header_y"), x += 61, y, -1, false);
        graphics.m_280614_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.header_z"), x += 41, y, -1, false);
    }

    private class ItemsScrollPanel
    extends ScrollPanel
    implements NarratableEntry {
        private final List<ListItem> items;
        private final Minecraft minecraft;
        private int contentHeight;
        private float partialTicks;
        private boolean dirty;

        public ItemsScrollPanel(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.items = Lists.newArrayList();
            this.minecraft = client;
        }

        public void addItem(ListItem item) {
            this.addItem(this.items.size(), item);
        }

        public void insertAfter(WaypointListItem item, ListItem after) {
            int index = this.items.indexOf(after);
            this.addItem(index >= 0 ? index + 1 : this.items.size(), item);
        }

        public void addItem(int index, ListItem item) {
            this.items.add(index, item);
            item.setParent(this);
            this.recalculateHeight();
            item.setWidth(this.getContentWidth());
            item.init();
        }

        protected int getContentHeight() {
            return this.contentHeight;
        }

        public void setPartialTicks(float partialTicks) {
            this.partialTicks = partialTicks;
        }

        protected void drawBackground(GuiGraphics graphics, Tesselator tess, float partialTick) {
            super.drawBackground(graphics, tess, partialTick);
            this.partialTicks = partialTick;
        }

        protected void drawPanel(GuiGraphics graphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            PoseStack mStack = graphics.m_280168_();
            mStack.m_85836_();
            mStack.m_252880_((float)this.left, (float)relativeY, 0.0f);
            for (ListItem item : this.items) {
                if (!item.isVisible()) continue;
                mStack.m_85836_();
                mStack.m_252880_(0.0f, (float)item.getTop(), 0.0f);
                item.render(graphics, mouseX, mouseY, this.partialTicks);
                mStack.m_85849_();
            }
            mStack.m_85849_();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.items;
        }

        public void recalculateHeight() {
            int totalHeight = 0;
            for (ListItem item : this.items) {
                if (!item.isVisible()) continue;
                item.setTop(totalHeight);
                totalHeight += item.getHeight();
            }
            this.contentHeight = totalHeight;
        }

        public int getLeft() {
            return this.left;
        }

        public int getTop() {
            return this.top;
        }

        public int getContentTop() {
            int baseY = this.top + this.border - (int)this.scrollDistance;
            return baseY;
        }

        public void saveAll() {
            this.items.forEach(item -> item.save());
        }

        public int getContentWidth() {
            return this.right - this.left - 6;
        }

        public void removeItem(ListItem item) {
            item.setParent(null);
            this.items.remove(item);
            this.recalculateHeight();
        }

        public void scrollToItem(ListItem item) {
            int scrollOffset = item.getTop() - this.height / 2 - item.getHeight();
            this.scrollDistance = Mth.m_14045_((int)scrollOffset, (int)0, (int)Math.max(0, this.getContentHeight() - (this.height - this.border)));
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            this.scrollDistance = Mth.m_14036_((float)this.scrollDistance, (float)0.0f, (float)Math.max(0, this.getContentHeight() - (this.height - this.border)));
            super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }

        public void scrollTop() {
            this.scrollDistance = 0.0f;
        }

        public void clear() {
            this.items.forEach(item -> item.setParent(null));
            this.items.clear();
        }

        protected void setDirty() {
            this.dirty = true;
            ClientWaypointManagerScreen.this.setDirty();
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }

    private class WorldListItem
    extends CompositeListItem {
        private final Component title;
        private final ResourceKey<Level> worldKey;
        private final List<WaypointListItem> waypoints;
        private final ResourceKey<DimensionType> dimensionTypeKey;
        private boolean folded;
        private NewWaypointListItem newWaypoint;

        public void setNewWaypoint(NewWaypointListItem newWaypoint) {
            this.newWaypoint = newWaypoint;
        }

        public WorldListItem(Minecraft minecraft, ResourceKey<Level> key, ResourceKey<DimensionType> dimensionTypeKey) {
            super(minecraft, 22);
            this.waypoints = Lists.newArrayList();
            this.title = Component.m_237110_((String)"text.hudcompass.waypoint_editor.world", (Object[])new Object[]{key.m_135782_()});
            this.worldKey = key;
            this.dimensionTypeKey = dimensionTypeKey;
        }

        @Override
        public void init() {
            super.init();
            this.addWidget(Button.m_253074_((Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.fold"), button -> {
                boolean bl = this.folded = !this.folded;
                if (this.folded) {
                    button.m_93666_((Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.unfold"));
                } else {
                    button.m_93666_((Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.fold"));
                }
                this.waypoints.forEach(w -> w.setVisible(!this.folded));
                this.newWaypoint.setVisible(!this.folded);
                ClientWaypointManagerScreen.this.scrollPanel.recalculateHeight();
            }).m_252794_(1, 1).m_253046_(20, 20).m_253136_());
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.render(graphics, mouseX, mouseY, partialTicks);
            graphics.m_280614_(this.minecraft.f_91062_, this.title, 24, 10, -1, false);
        }

        public void addWaypoint(WaypointListItem item) {
            this.waypoints.add(item);
        }

        public void removeWaypoint(WaypointListItem item) {
            this.waypoints.remove(item);
        }
    }

    private class WaypointListItem
    extends CompositeListItem {
        private final BasicWaypoint pointInfo;
        private final WorldListItem worldItem;
        private EditBox label;
        private EditBox xCoord;
        private EditBox yCoord;
        private EditBox zCoord;
        private Button changeSymbol;
        private Button delete;
        private String labelText;
        private String xText;
        private String yText;
        private String zText;

        public WaypointListItem(Minecraft minecraft, BasicWaypoint pointInfo, WorldListItem worldItem) {
            super(minecraft, 22);
            this.pointInfo = pointInfo;
            this.worldItem = worldItem;
        }

        @Override
        public void init() {
            super.init();
            Vec3 pos = this.pointInfo.getPosition();
            int nameWidth = Math.max(this.getWidth() - 212, 50);
            int x = 2;
            this.label = this.addWidget(new EditBox(this.minecraft.f_91062_, x + 1, 2, nameWidth, 16, (Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.header_label")));
            this.xCoord = this.addWidget(new EditBox(this.minecraft.f_91062_, (x += nameWidth + 3) + 1, 2, 60, 16, (Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.header_x")));
            this.yCoord = this.addWidget(new EditBox(this.minecraft.f_91062_, (x += 61) + 1, 2, 40, 16, (Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.header_y")));
            this.zCoord = this.addWidget(new EditBox(this.minecraft.f_91062_, (x += 41) + 1, 2, 60, 16, (Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.header_z")));
            this.changeSymbol = this.addWidget(Button.m_253074_((Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.change_symbol"), button -> {}).m_252794_(x += 63, 0).m_253046_(20, 20).m_253136_());
            this.delete = this.addWidget(Button.m_253074_((Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.delete"), button -> ClientWaypointManagerScreen.this.deletePoint(this)).m_252794_(x += 21, 0).m_253046_(20, 20).m_253136_());
            this.changeSymbol.f_93623_ = false;
            this.label.m_94199_(1024);
            this.label.m_94144_(this.pointInfo.getLabelText());
            this.xCoord.m_94144_(String.format(Locale.ROOT, "%1.2f", pos.f_82479_));
            this.yCoord.m_94144_(String.format(Locale.ROOT, "%1.2f", pos.f_82480_));
            this.zCoord.m_94144_(String.format(Locale.ROOT, "%1.2f", pos.f_82481_));
            this.xCoord.m_94153_(COORD_VALIDATOR.asPredicate());
            this.yCoord.m_94153_(COORD_VALIDATOR.asPredicate());
            this.zCoord.m_94153_(COORD_VALIDATOR.asPredicate());
            this.label.m_94151_(str -> {
                this.labelText = str != null ? str : "";
                this.setDirty();
            });
            this.xCoord.m_94151_(str -> {
                this.xText = str != null ? str : "";
                this.setDirty();
            });
            this.yCoord.m_94151_(str -> {
                this.yText = str != null ? str : "";
                this.setDirty();
            });
            this.zCoord.m_94151_(str -> {
                this.zText = str != null ? str : "";
                this.setDirty();
            });
        }

        @Override
        public void save() {
            if (this.isDirty()) {
                this.labelText = this.label.m_94155_();
                this.xText = this.xCoord.m_94155_();
                this.yText = this.yCoord.m_94155_();
                this.zText = this.zCoord.m_94155_();
                if (COORD_FORMAT_MATCHER.test(this.xText) && COORD_FORMAT_MATCHER.test(this.yText) && COORD_FORMAT_MATCHER.test(this.zText)) {
                    this.pointInfo.setLabelText(this.labelText == null ? "" : this.labelText);
                    this.pointInfo.setPosition(new Vec3(Double.parseDouble(this.xText), Double.parseDouble(this.yText), Double.parseDouble(this.zText)));
                }
                if (!ClientWaypointManagerScreen.this.toAdd.contains(this)) {
                    ClientWaypointManagerScreen.this.toUpdate.add(this);
                }
            }
        }
    }

    private static abstract class ListItem
    implements ContainerEventHandler,
    NarratableEntry {
        protected final Minecraft minecraft;
        @Nullable
        private ItemsScrollPanel parent;
        private int height;
        private int width;
        private int top;
        private boolean visible = true;
        private boolean dirty;
        @Nullable
        private GuiEventListener focused;
        private boolean isDragging;

        public ListItem(Minecraft minecraft, int height) {
            this.minecraft = minecraft;
            this.height = height;
        }

        public int getTop() {
            return this.top;
        }

        public void setTop(int top) {
            this.top = top;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
            if (this.parent != null) {
                this.parent.recalculateHeight();
            }
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        @Nullable
        public ItemsScrollPanel getParent() {
            return this.parent;
        }

        public void setParent(@Nullable ItemsScrollPanel parent) {
            this.parent = parent;
        }

        public void init() {
        }

        public abstract void render(GuiGraphics var1, int var2, int var3, float var4);

        public void save() {
        }

        protected boolean isDirty() {
            return this.dirty;
        }

        protected void setDirty() {
            this.dirty = true;
            if (this.parent != null) {
                this.parent.setDirty();
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            if (this.visible != visible) {
                this.visible = visible;
            }
        }

        public final boolean m_7282_() {
            return this.isDragging;
        }

        public final void m_7897_(boolean pDragging) {
            this.isDragging = pDragging;
        }

        @Nullable
        public GuiEventListener m_7222_() {
            return this.focused;
        }

        public void m_7522_(@Nullable GuiEventListener pListener) {
            if (this.focused != null) {
                this.focused.m_93692_(false);
            }
            if (pListener != null) {
                pListener.m_93692_(true);
            }
            this.focused = pListener;
        }
    }

    private class NewWaypointListItem
    extends CompositeListItem {
        WorldListItem owner;

        public NewWaypointListItem(Minecraft minecraft, WorldListItem owner) {
            super(minecraft, 24);
            this.owner = owner;
        }

        @Override
        public void init() {
            super.init();
            this.addWidget(Button.m_253074_((Component)Component.m_237115_((String)"text.hudcompass.waypoint_editor.new_waypoint"), button -> ClientWaypointManagerScreen.this.createNewPoint(this.owner)).m_252794_(this.getWidth() - 121, 1).m_253046_(120, 20).m_253136_());
        }
    }

    private static class CompositeListItem
    extends ListItem {
        private final List<AbstractWidget> renderables = Lists.newArrayList();

        public CompositeListItem(Minecraft minecraft, int height) {
            super(minecraft, height);
        }

        @Override
        public void init() {
            super.init();
            this.renderables.clear();
        }

        public <T extends AbstractWidget> T addWidget(T widget) {
            this.renderables.add(widget);
            return widget;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.renderables;
        }

        private int getActualX(int mouseX) {
            int x = mouseX;
            if (this.getParent() != null) {
                x -= this.getParent().getLeft();
            }
            return x;
        }

        private double getActualX(double mouseX) {
            double x = mouseX;
            if (this.getParent() != null) {
                x -= (double)this.getParent().getLeft();
            }
            return x;
        }

        private int getActualY(int mouseY) {
            int y = mouseY - this.getTop();
            if (this.getParent() != null) {
                y -= this.getParent().getContentTop();
            }
            return y;
        }

        private double getActualY(double mouseY) {
            double y = mouseY - (double)this.getTop();
            if (this.getParent() != null) {
                y -= (double)this.getParent().getContentTop();
            }
            return y;
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            if (!this.isVisible()) {
                return;
            }
            int actualMouseX = this.getActualX(mouseX);
            int actualMouseY = this.getActualY(mouseY);
            if (actualMouseX >= 0 && actualMouseX < this.getWidth() && actualMouseY >= 0 && actualMouseY <= this.getHeight()) {
                graphics.m_280509_(0, 0, this.getWidth(), this.getHeight(), 0x1FFFFFFF);
            }
            for (AbstractWidget i : this.renderables) {
                i.m_88315_(graphics, actualMouseX, actualMouseY, partialTicks);
            }
        }

        public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
            if (!this.isVisible()) {
                return Optional.empty();
            }
            double actualMouseX = this.getActualX(mouseX);
            double actualMouseY = this.getActualY(mouseY);
            for (GuiEventListener guiEventListener : this.m_6702_()) {
                if (!guiEventListener.m_5953_(actualMouseX, actualMouseY)) continue;
                return Optional.of(guiEventListener);
            }
            return Optional.empty();
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!this.isVisible()) {
                return false;
            }
            double actualMouseX = this.getActualX(mouseX);
            double actualMouseY = this.getActualY(mouseY);
            for (GuiEventListener guiEventListener : this.m_6702_()) {
                if (!guiEventListener.m_6375_(actualMouseX, actualMouseY, button)) continue;
                this.m_7522_(guiEventListener);
                if (button == 0) {
                    this.m_7897_(true);
                }
                return true;
            }
            return false;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            if (!this.isVisible()) {
                return false;
            }
            double actualMouseX = this.getActualX(mouseX);
            double actualMouseY = this.getActualY(mouseY);
            this.m_7897_(false);
            return this.m_94729_(mouseX, mouseY).filter(listener -> listener.m_6348_(actualMouseX, actualMouseY, button)).isPresent();
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (!this.isVisible()) {
                return false;
            }
            double actualMouseX = this.getActualX(mouseX);
            double actualMouseY = this.getActualY(mouseY);
            return this.m_7222_() != null && this.m_7282_() && button == 0 && this.m_7222_().m_7979_(actualMouseX, actualMouseY, button, dragX, dragY);
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            if (!this.isVisible()) {
                return false;
            }
            double actualMouseX = this.getActualX(mouseX);
            double actualMouseY = this.getActualY(mouseY);
            return this.m_94729_(mouseX, mouseY).filter(listener -> listener.m_6050_(actualMouseX, actualMouseY, delta)).isPresent();
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

