/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.client;

import com.google.common.io.Files;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="hudcompass", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientWaypointDatabase {
    private static final Logger LOGGER = LogManager.getLogger();

    private static Path getPath(Minecraft mc) {
        Object address;
        if (mc.m_91090_()) {
            return mc.m_91092_().m_6237_().toPath().resolve("client_waypoints").resolve("waypoints.dat").toAbsolutePath();
        }
        Connection networkManager = mc.f_91074_.f_108617_.m_104910_();
        SocketAddress addr = networkManager.m_129523_();
        if (addr instanceof InetSocketAddress) {
            InetSocketAddress ip = (InetSocketAddress)addr;
            address = ip.getHostString() + "_" + ip.getPort();
        } else {
            address = addr.toString();
        }
        ResourceLocation dim = mc.f_91074_.m_9236_().m_46472_().m_135782_();
        String dimension = dim.m_135827_() + "_" + dim.m_135815_();
        return FMLPaths.GAMEDIR.get().resolve("server_waypoints").resolve((String)address).resolve(dimension).resolve("waypoints.dat").toAbsolutePath();
    }

    private static void populateFromDisk(Minecraft mc) {
        mc.f_91074_.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
            File backup;
            if (pois.otherSideHasMod) {
                return;
            }
            LOGGER.debug("Joined new dimension, loading...");
            Path filePath = ClientWaypointDatabase.getPath(mc);
            File file = filePath.toFile();
            if (!file.exists() && (backup = new File(file.getAbsolutePath() + ".bak")).exists()) {
                file = backup;
                LOGGER.debug("File did not exist, but a backup was found...");
            }
            if (file.exists()) {
                try {
                    CompoundTag tag = NbtIo.m_128953_((File)file);
                    pois.clear();
                    ListTag list0 = tag.m_128437_("Worlds", 10);
                    pois.read(list0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                LOGGER.debug("Done!");
            } else {
                LOGGER.debug("File did not exist.");
            }
        });
    }

    private static void saveToDisk(Minecraft mc) {
        mc.f_91074_.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
            if (pois.otherSideHasMod) {
                return;
            }
            if (pois.changeNumber > pois.savedNumber) {
                LOGGER.debug("Changes detected, saving.");
                try {
                    Path filePath = ClientWaypointDatabase.getPath(mc);
                    File file = filePath.toFile();
                    if (file.exists()) {
                        LOGGER.debug("File already exists, keeping as backup.");
                        File backup = new File(file.getAbsolutePath() + ".bak");
                        Files.copy((File)file, (File)backup);
                    } else {
                        file.getParentFile().mkdirs();
                    }
                    CompoundTag tag0 = new CompoundTag();
                    ListTag list0 = pois.write();
                    tag0.m_128365_("Worlds", (Tag)list0);
                    NbtIo.m_128955_((CompoundTag)tag0, (File)file);
                    pois.savedNumber = pois.changeNumber;
                    LOGGER.debug("Done!");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            ClientWaypointDatabase.saveToDisk(mc);
        }
    }

    @SubscribeEvent
    public static void entityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().f_46443_ && event.getEntity() instanceof LocalPlayer) {
            ClientWaypointDatabase.populateFromDisk(Minecraft.m_91087_());
        }
    }
}

