/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.client.ClientWaypointManagerScreen;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.network.ClientHello;
import dev.gigaherz.hudcompass.network.RemoveWaypoint;
import dev.gigaherz.hudcompass.waypoints.BasicWaypoint;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="hudcompass", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientHandler {
    public static KeyMapping ADD_WAYPOINT;
    public static KeyMapping REMOVE_WAYPOINT;
    public static KeyMapping EDIT_WAYPOINTS;

    @SubscribeEvent
    public static void handleKeys(TickEvent.ClientTickEvent ev) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (ADD_WAYPOINT.m_90859_()) {
            mc.f_91074_.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
                Vec3 position = mc.f_91074_.m_20182_();
                String label = String.format("{%1.2f, %1.2f, %1.2f}", position.m_7096_(), position.m_7098_(), position.m_7094_());
                pois.get(mc.f_91074_.m_9236_()).addPointRequest(new BasicWaypoint(position, label, BasicIconData.mapMarker(7)));
            });
            while (ADD_WAYPOINT.m_90859_()) {
            }
        }
        if (REMOVE_WAYPOINT.m_90859_()) {
            mc.f_91074_.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
                PointInfo<?> targetted = pois.getTargetted();
                if (targetted != null && !targetted.isDynamic()) {
                    if (pois.otherSideHasMod) {
                        HudCompass.channel.sendToServer((Object)new RemoveWaypoint(targetted));
                    } else {
                        pois.get(mc.f_91074_.m_9236_()).removePointRequest(targetted);
                    }
                }
            });
            while (ADD_WAYPOINT.m_90859_()) {
            }
        }
        if (EDIT_WAYPOINTS.m_90859_()) {
            mc.f_91074_.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> mc.m_91152_((Screen)new ClientWaypointManagerScreen((PointsOfInterest)pois)));
            while (ADD_WAYPOINT.m_90859_()) {
            }
        }
    }

    @SubscribeEvent
    public static void clientTickEvent(TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            PointsOfInterest.onTick((Player)player);
        }
    }

    public static void handleWaypointSync(byte[] bytes) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        PointsOfInterest.handleSync((Player)player, bytes);
    }

    public static void handleServerHello() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            PointsOfInterest.remoteHello((Player)player);
        }
        HudCompass.channel.sendToServer((Object)new ClientHello());
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="hudcompass", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        public static void initKeybinds(RegisterKeyMappingsEvent event) {
            ADD_WAYPOINT = new KeyMapping("key.hudcompass.add_waypoint", InputConstants.f_84822_.m_84873_(), "key.hudcompass.category");
            event.register(ADD_WAYPOINT);
            REMOVE_WAYPOINT = new KeyMapping("key.hudcompass.remove_waypoint", InputConstants.f_84822_.m_84873_(), "key.hudcompass.category");
            event.register(REMOVE_WAYPOINT);
            EDIT_WAYPOINTS = new KeyMapping("key.hudcompass.edit_waypoints", InputConstants.f_84822_.m_84873_(), "key.hudcompass.category");
            event.register(EDIT_WAYPOINTS);
        }
    }
}

