/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigData {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static boolean alwaysShowLabels;
    public static boolean alwaysShowFocusedLabel;
    public static boolean showAllLabelsOnSneak;
    public static boolean animateLabels;
    public static DisplayWhen displayWhen;
    public static boolean enableJourneymapIntegration;
    public static double waypointViewDistance;
    public static double waypointFadeDistance;
    public static PlayerDisplay playerDisplay;

    public static void refreshClient() {
        alwaysShowLabels = (Boolean)ConfigData.CLIENT.alwaysShowLabels.get();
        alwaysShowFocusedLabel = (Boolean)ConfigData.CLIENT.alwaysShowFocusedLabel.get();
        showAllLabelsOnSneak = (Boolean)ConfigData.CLIENT.showAllLabelsOnSneak.get();
        animateLabels = (Boolean)ConfigData.CLIENT.animateLabels.get();
        displayWhen = (DisplayWhen)((Object)ConfigData.CLIENT.displayWhen.get());
        waypointFadeDistance = (Double)ConfigData.CLIENT.waypointFadeDistance.get();
        waypointViewDistance = (Double)ConfigData.CLIENT.waypointViewDistance.get();
        enableJourneymapIntegration = (Boolean)ConfigData.CLIENT.enableJourneymapIntegration.get();
    }

    public static void refreshCommon() {
        playerDisplay = (PlayerDisplay)((Object)ConfigData.COMMON.playerDisplay.get());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue alwaysShowLabels;
        public final ForgeConfigSpec.BooleanValue alwaysShowFocusedLabel;
        public final ForgeConfigSpec.BooleanValue showAllLabelsOnSneak;
        public final ForgeConfigSpec.BooleanValue animateLabels;
        public final ForgeConfigSpec.BooleanValue enableJourneymapIntegration;
        public final ForgeConfigSpec.EnumValue<DisplayWhen> displayWhen;
        public final ForgeConfigSpec.DoubleValue waypointFadeDistance;
        public final ForgeConfigSpec.DoubleValue waypointViewDistance;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("display");
            this.alwaysShowLabels = builder.comment("If set to TRUE, the labels on the compass will always be visible, if FALSE (default), only the closest to the center of the compass will show the name.").define("alwaysShowLabels", false);
            this.alwaysShowFocusedLabel = builder.comment("If set to FALSE, the closest waypoint to the center of the compass will not show the label, and sneak will be required to display it.").define("alwaysShowFocusedLabel", true);
            this.showAllLabelsOnSneak = builder.comment("If set to FALSE, sneaking will only show the closest waypoint to the center of the compass.").define("showAllLabelsOnSneak", true);
            this.animateLabels = builder.comment("If set to FALSE, support for sewing recipes will not be enabled regardless of the mod's presence.").define("animateLabels", true);
            this.displayWhen = builder.comment(new String[]{"Choose when the compass is visible.", " - NEVER: Don't display the compass (the mod remains active, just doesn't render).", " - HAS_COMPASS: Only display HUD if a compass is in the inventory.", " - HOLDING_COMPASS: Only display HUD if a compass is in the hand.", " - ALWAYS: Always display the compass (default)."}).defineEnum("displayWhen", (Enum)DisplayWhen.HOLDING_COMPASS);
            this.enableJourneymapIntegration = builder.comment("If set to FALSE, Journeymap waypoints won't be displayed in the compass.").define("enableJourneymapIntegration", true);
            this.waypointFadeDistance = builder.comment("Sets the distance at which waypoints start to fade. Meaningless if waypointViewDistance=0. If this value is >= waypointViewDistance, it will never fade.").defineInRange("waypointFadeDistance", 195.0, 0.0, Double.MAX_VALUE);
            this.waypointViewDistance = builder.comment("Sets the distance at which waypoints stop drawing. If set to 0, waypoints will never disappear.").defineInRange("waypointViewDistance", 200.0, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static enum DisplayWhen {
        NEVER,
        HOLDING_COMPASS,
        HAS_COMPASS,
        ALWAYS;

    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue enableVanillaMapIntegration;
        public final ForgeConfigSpec.BooleanValue enableSpawnPointWaypoint;
        public final ForgeConfigSpec.BooleanValue disableServerHello;
        public final ForgeConfigSpec.EnumValue<PlayerDisplay> playerDisplay;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.enableVanillaMapIntegration = builder.comment("If set to FALSE, vanilla map waypoints won't be displayed in the compass.").define("enableVanillaMapIntegration", true);
            this.enableSpawnPointWaypoint = builder.comment("If set to FALSE, the spawn point location will not be shown.").define("enableSpawnPointWaypoint", true);
            this.disableServerHello = builder.comment("If set to TRUE, the server will not advertise itself to the clients, making them work in client-only mode.").define("disableServerHello", false);
            this.playerDisplay = builder.comment(new String[]{"Choose how the compass shows other players.", " - NONE: Don't display other players, ever.", " - TEAM (default): Only display players that are in the same team.", " - ALL: Display all players."}).defineEnum("playerDisplay", (Enum)PlayerDisplay.TEAM);
            builder.pop();
        }
    }

    public static enum PlayerDisplay {
        NONE,
        TEAM,
        ALL;

    }

    public static class ServerConfig {
        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            builder.pop();
        }
    }
}

