/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.hitfeedback.network;

import dev.architectury.networking.NetworkManager;
import java.util.Optional;
import java.util.function.Supplier;
import mod.chloeprime.hitfeedback.client.HitFeedbackClient;
import mod.chloeprime.hitfeedback.common.HitFeedbackType;
import mod.chloeprime.hitfeedback.common.HitFeedbackTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class S2CHitFeedback {
    public final int entityId;
    public final HitFeedbackType type;
    public final Vec3 position;
    public final Vec3 velocity;
    public final float strength;

    public S2CHitFeedback(Entity entity, HitFeedbackType type, Vec3 position, Vec3 velocity, float strength) {
        this.entityId = entity.m_19879_();
        this.type = type;
        this.position = position;
        this.velocity = velocity;
        this.strength = strength;
    }

    @NotNull
    public Entity getEntity(Level level) {
        return Optional.ofNullable(level.m_6815_(this.entityId)).orElseThrow(() -> new IllegalStateException("Invalid entity ID"));
    }

    public S2CHitFeedback(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        ResourceLocation fbTypeId = buf.m_130281_();
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        double normalX = buf.readDouble();
        double normalY = buf.readDouble();
        double normalZ = buf.readDouble();
        this.strength = buf.readFloat();
        this.type = Optional.ofNullable((HitFeedbackType)HitFeedbackTypes.REGISTRY.get(fbTypeId)).orElseThrow(() -> new IllegalStateException("Unknown feedback type: %s".formatted(fbTypeId)));
        this.position = new Vec3(posX, posY, posZ);
        this.velocity = new Vec3(normalX, normalY, normalZ);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_130085_(Optional.ofNullable(HitFeedbackTypes.REGISTRY.getId((Object)this.type)).orElseThrow(() -> new IllegalStateException("Unregistered feedback type: %s".formatted(this.type))));
        buf.writeDouble(this.position.f_82479_);
        buf.writeDouble(this.position.f_82480_);
        buf.writeDouble(this.position.f_82481_);
        buf.writeDouble(this.velocity.f_82479_);
        buf.writeDouble(this.velocity.f_82480_);
        buf.writeDouble(this.velocity.f_82481_);
        buf.writeFloat(this.strength);
    }

    public void handle(Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> HitFeedbackClient.handleFeedbackPacket(this, (NetworkManager.PacketContext)ctx.get()));
    }
}

