/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.hitfeedback.mixin.compat.azurelib.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.chloeprime.hitfeedback.client.internal.SizedTexture;
import mod.chloeprime.hitfeedback.util.ImageHelper;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnimatableTexture.class}, remap=false)
public class MixinAzureLibTexture
extends SimpleTexture
implements SizedTexture {
    @Unique
    private int hit_feedback$w;
    @Unique
    private int hit_feedback$h;
    @Unique
    private volatile float hit_feedback$fillRate = 0.6f;

    @Override
    public int hit_feedback$getWidth() {
        return this.hit_feedback$w;
    }

    @Override
    public int hit_feedback$getHeight() {
        return this.hit_feedback$h;
    }

    @Override
    public float hit_feedback$getFillRate() {
        return this.hit_feedback$fillRate;
    }

    @Inject(method={"load"}, at={@At(value="RETURN")}, remap=true)
    private void calculateFrameSize(ResourceManager manager, CallbackInfo ci) throws IOException {
        Optional res = manager.m_213713_(this.f_118129_);
        if (res.isEmpty()) {
            return;
        }
        Resource resource = (Resource)res.get();
        try (InputStream imageFile = resource.m_215507_();
             NativeImage image = NativeImage.m_85058_((InputStream)imageFile);){
            int w = image.m_84982_();
            int h = image.m_85084_();
            this.hit_feedback$fillRate = ImageHelper.getFillRate(image);
            ResourceMetadata meta = resource.m_215509_();
            meta.m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).ifPresentOrElse(section -> {
                FrameSize size = section.m_245821_(w, h);
                this.hit_feedback$w = size.f_244129_();
                this.hit_feedback$h = size.f_244503_();
            }, () -> {
                this.hit_feedback$w = image.m_84982_();
                this.hit_feedback$h = image.m_85084_();
            });
        }
    }

    public MixinAzureLibTexture(ResourceLocation location) {
        super(location);
    }
}

