/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.hitfeedback.common;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import mod.chloeprime.hitfeedback.HitFeedbackMod;
import mod.chloeprime.hitfeedback.common.HitFeedbackTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class HitFeedbackType {
    @Nullable
    private final TagKey<EntityType<?>> tag;
    @Nullable
    private final Supplier<SoundEvent> sound;
    private final Set<Options> options;

    public HitFeedbackType(@Nullable Supplier<SoundEvent> sound, Options ... options) {
        this(sound, (TagKey<EntityType<?>>)null, options);
    }

    public HitFeedbackType(@Nullable Supplier<SoundEvent> sound, @Nullable TagKey<EntityType<?>> tag, Options ... options) {
        this.tag = tag;
        this.sound = sound;
        this.options = Collections.newSetFromMap(new IdentityHashMap());
        this.options.addAll(List.of(options));
    }

    public Optional<SoundEvent> getHitSound() {
        return Optional.ofNullable(this.sound).map(Supplier::get);
    }

    public boolean isServerOnly() {
        return this.options.contains(Options.SERVER_ONLY);
    }

    public static HitFeedbackType match(DamageSource source, LivingEntity victim, boolean valid) {
        return HitFeedbackTypes.REGISTRY.entrySet().stream().map(Map.Entry::getValue).filter(type -> type.tag != null && victim.m_6095_().m_204039_(type.tag)).findFirst().orElseGet(() -> HitFeedbackType.matchDefault(source, victim, valid));
    }

    private static HitFeedbackType matchDefault(DamageSource source, LivingEntity victim, boolean valid) {
        boolean isHoldingSword;
        Entity attacker = source.m_7639_();
        boolean isGunshot = source.m_269014_();
        boolean bl = isHoldingSword = !isGunshot && HitFeedbackType.isHoldingSword(attacker);
        if (!valid) {
            return isHoldingSword ? (HitFeedbackType)HitFeedbackTypes.METAL_FAILURE.get() : (HitFeedbackType)HitFeedbackTypes.PUNCH.get();
        }
        if (victim instanceof AbstractSkeleton) {
            return (HitFeedbackType)HitFeedbackTypes.BONE.get();
        }
        if (victim instanceof Slime) {
            return isHoldingSword ? (HitFeedbackType)HitFeedbackTypes.SLIME_SWORD.get() : (HitFeedbackType)HitFeedbackTypes.SLIME_GUNSHOT.get();
        }
        return isGunshot ? (HitFeedbackType)HitFeedbackTypes.FLESH_GUNSHOT.get() : (isHoldingSword ? (HitFeedbackType)HitFeedbackTypes.FLESH_SWORD.get() : (HitFeedbackType)HitFeedbackTypes.PUNCH.get());
    }

    private static boolean isHoldingSword(Entity attacker) {
        if (!(attacker instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingAttacker = (LivingEntity)attacker;
        return HitFeedbackType.isWeapon(livingAttacker.m_21205_(), EquipmentSlot.MAINHAND) || HitFeedbackType.isWeapon(livingAttacker.m_21206_(), EquipmentSlot.OFFHAND);
    }

    private static boolean isWeapon(ItemStack stack, EquipmentSlot hand) {
        if (HitFeedbackMod.isSharpWeapon(stack)) {
            return true;
        }
        return stack.m_41720_().m_7167_(hand).get((Object)Attributes.f_22281_).stream().anyMatch(mdf -> mdf.m_22217_() == AttributeModifier.Operation.ADDITION && mdf.m_22218_() > 0.0);
    }

    public static interface Options {
        public static final Options SERVER_ONLY = new Options(){};
    }
}

